/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.filter.predicate.ObjectSourcePlayer;
import mage.filter.predicate.other.PlayerWithTheMostLifePredicate;
import mage.game.Game;
import mage.players.Player;

public enum SourceAttackingPlayerWithMostLifeCondition implements Condition
{
    instance;


    @Override
    public boolean apply(Game game, Ability source) {
        UUID defenderId = game.getCombat().getDefenderId(source.getSourceId());
        if (defenderId == null) {
            return false;
        }
        Player attackedPlayer = game.getPlayer(defenderId);
        return PlayerWithTheMostLifePredicate.instance.apply(new ObjectSourcePlayer<Player>(attackedPlayer, source.getControllerId(), source), game);
    }

    public String toString() {
        return "it's attacking the player with the most life or tied for most life";
    }
}

