/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.game.Game;

public class SourceHasRemainedInSameZoneCondition
implements Condition {
    UUID idToCheck = null;
    int timesChangedZones = -1;

    public SourceHasRemainedInSameZoneCondition(UUID idToCheck) {
        this.idToCheck = idToCheck;
        this.timesChangedZones = -1;
    }

    public SourceHasRemainedInSameZoneCondition(UUID idToCheck, Game game) {
        this.idToCheck = idToCheck;
        this.timesChangedZones = -1;
        if (this.idToCheck != null && game != null && game.getCard(this.idToCheck) != null) {
            this.timesChangedZones = game.getState().getZoneChangeCounter(this.idToCheck);
        }
    }

    public SourceHasRemainedInSameZoneCondition getInstance(UUID cardId) {
        return new SourceHasRemainedInSameZoneCondition(cardId);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        if (this.idToCheck != null && game.getCard(this.idToCheck) != null) {
            if (this.timesChangedZones == -1) {
                this.timesChangedZones = game.getState().getZoneChangeCounter(this.idToCheck);
            }
            if (this.timesChangedZones == game.getState().getZoneChangeCounter(this.idToCheck)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "if {this} has remained in the same zone";
    }
}

