/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.constants.Zone;
import mage.game.Game;

public class SourceRemainsInZoneCondition
implements Condition {
    private final Zone zone;
    private int timesChangedZones = -1;

    public SourceRemainsInZoneCondition(Zone zone) {
        this.zone = zone;
        this.timesChangedZones = -1;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        if (this.timesChangedZones == -1) {
            this.timesChangedZones = game.getState().getZoneChangeCounter(source.getSourceId());
        }
        return this.timesChangedZones == game.getState().getZoneChangeCounter(source.getSourceId()) && this.zone.equals((Object)game.getState().getZone(source.getSourceId()));
    }

    public String toString() {
        return "for as long as {this} remains on the " + this.zone.toString();
    }
}

