/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;

public enum TwoTappedCreaturesCondition implements Condition
{
    instance;

    private static final FilterPermanent filter;
    private static final Hint hint;

    public static Hint getHint() {
        return hint;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return game.getBattlefield().contains(filter, source.getControllerId(), source, game, 2);
    }

    public String toString() {
        return "you control two or more tapped creatures";
    }

    static {
        filter = new FilterControlledCreaturePermanent();
        filter.add(TappedPredicate.TAPPED);
        hint = new ValueHint("Tapped creatures you control", new PermanentsOnBattlefieldCount(filter));
    }
}

