/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.hint.ConditionHint;
import mage.abilities.hint.Hint;
import mage.constants.ComparisonType;
import mage.filter.FilterPermanent;
import mage.util.CardUtil;

public class YouControlPermanentCondition
extends PermanentsOnTheBattlefieldCondition {
    public Hint getHint() {
        return new ConditionHint(this);
    }

    public YouControlPermanentCondition(FilterPermanent filter) {
        this(filter, ComparisonType.OR_GREATER, 1);
    }

    public YouControlPermanentCondition(FilterPermanent filter, ComparisonType comparisonType, int count) {
        super(filter, comparisonType, count, true);
    }

    @Override
    public String toString() {
        String text = "you control ";
        String filterText = this.filter.getMessage();
        if (filterText.endsWith(" you control")) {
            filterText = filterText.substring(0, filterText.length() - " you control".length());
        }
        switch (this.type) {
            case OR_LESS: {
                text = text + CardUtil.numberToText(this.count) + " or fewer " + filterText;
                break;
            }
            case OR_GREATER: {
                if (this.count == 1) {
                    text = text + CardUtil.addArticle(filterText);
                    break;
                }
                text = text + CardUtil.numberToText(this.count) + " or more " + filterText;
                break;
            }
            case EQUAL_TO: {
                if (this.count == 0) {
                    text = text + "no " + filterText;
                    break;
                }
                text = text + "exactly " + CardUtil.numberToText(this.count) + " " + filterText;
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong code usage: ComparisonType not handled in text generation: " + (Object)((Object)this.type));
            }
        }
        return text;
    }
}

