/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs;

import mage.abilities.costs.AlternativeCost;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.mana.ManaCost;
import mage.game.Game;
import mage.util.CardUtil;

public class AlternativeCostImpl<T extends AlternativeCostImpl<T>>
extends CostsImpl<Cost>
implements AlternativeCost {
    protected String name;
    protected final String reminderText;
    protected boolean isMana;
    protected boolean activated;

    public AlternativeCostImpl(String name, String reminderText, Cost cost) {
        this.activated = false;
        this.name = name;
        this.isMana = cost instanceof ManaCost;
        this.reminderText = reminderText;
        this.add(cost);
    }

    protected AlternativeCostImpl(AlternativeCostImpl<?> cost) {
        super(cost);
        this.name = cost.name;
        this.reminderText = cost.reminderText;
        this.activated = cost.activated;
        this.isMana = cost.isMana;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getText(boolean onlyCost) {
        if (onlyCost) {
            return this.getText();
        }
        String costName = this.name != null ? this.name : "";
        String delimiter = !this.isMana || !costName.isEmpty() && costName.substring(costName.length() - 1).matches("\\d") ? "&mdash;" : " ";
        return costName + delimiter + this.getText() + (this.isMana ? "" : Character.valueOf('.'));
    }

    @Override
    public String getReminderText() {
        if (this.reminderText != null && !this.reminderText.isEmpty()) {
            return "<i>(" + this.reminderText.replace("{cost}", CardUtil.getTextWithFirstCharLowerCase(this.getText(true))) + ")</i>";
        }
        return "";
    }

    @Override
    public String getCastSuffixMessage(int position) {
        StringBuilder sb = new StringBuilder(position > 0 ? " and " : "").append(" with ");
        sb.append(this.name);
        return sb.toString();
    }

    @Override
    public void activate() {
        this.activated = true;
    }

    @Override
    public void reset() {
        this.activated = false;
    }

    @Override
    public boolean isActivated(Game game) {
        return this.activated;
    }

    @Override
    public AlternativeCostImpl<?> copy() {
        return new AlternativeCostImpl<T>(this);
    }

    @Override
    public Cost getCost() {
        if (this.iterator().hasNext()) {
            return (Cost)this.iterator().next();
        }
        return null;
    }
}

