/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.game.Game;
import mage.target.Targets;

public class CompositeCost
implements Cost {
    private final Cost firstCost;
    private final Cost secondCost;
    private String description;

    public CompositeCost(Cost firstCost, Cost secondCost, String description) {
        this.firstCost = firstCost;
        this.secondCost = secondCost;
        this.description = description;
    }

    protected CompositeCost(CompositeCost cost) {
        this.firstCost = cost.firstCost.copy();
        this.secondCost = cost.secondCost.copy();
        this.description = cost.description;
    }

    @Override
    public UUID getId() {
        throw new RuntimeException("Not supported method");
    }

    @Override
    public CompositeCost setText(String text) {
        this.description = text;
        return this;
    }

    @Override
    public String getText() {
        return this.description;
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return this.firstCost.canPay(ability, source, controllerId, game) && this.secondCost.canPay(ability, source, controllerId, game);
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana) {
        return this.pay(ability, game, source, controllerId, noMana, this);
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        return this.firstCost.pay(ability, game, source, controllerId, noMana, costToPay) && this.secondCost.pay(ability, game, source, controllerId, noMana, costToPay);
    }

    @Override
    public boolean isPaid() {
        return this.firstCost.isPaid() && this.secondCost.isPaid();
    }

    @Override
    public void clearPaid() {
        this.firstCost.clearPaid();
        this.secondCost.clearPaid();
    }

    @Override
    public void setPaid() {
        this.firstCost.setPaid();
        this.secondCost.setPaid();
    }

    @Override
    public Targets getTargets() {
        Targets res = new Targets();
        res.addAll(this.firstCost.getTargets());
        res.addAll(this.secondCost.getTargets());
        return res.withReadOnly();
    }

    @Override
    public CompositeCost copy() {
        return new CompositeCost(this);
    }
}

