/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.game.Game;
import mage.target.Target;
import mage.target.Targets;

public abstract class CostImpl
implements Cost {
    protected UUID id;
    protected String text;
    protected boolean paid;
    private Targets targets;

    public CostImpl() {
        this.id = UUID.randomUUID();
        this.paid = false;
        this.targets = null;
    }

    protected CostImpl(CostImpl cost) {
        this.id = cost.id;
        this.text = cost.text;
        this.paid = cost.paid;
        this.targets = cost.targets == null ? null : cost.targets.copy();
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana) {
        return this.pay(ability, game, source, controllerId, noMana, this);
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public Cost setText(String text) {
        this.text = text;
        return this;
    }

    private void prepareTargets() {
        if (this.targets == null) {
            this.targets = new Targets();
        }
    }

    public void addTarget(Target target) {
        if (target == null) {
            throw new IllegalArgumentException("Wrong code usage: can't add nullable target to the cost");
        }
        this.prepareTargets();
        this.targets.add(target);
    }

    @Override
    public Targets getTargets() {
        this.prepareTargets();
        return this.targets;
    }

    @Override
    public boolean isPaid() {
        return this.paid;
    }

    @Override
    public void clearPaid() {
        this.paid = false;
        this.prepareTargets();
        this.targets.clearChosen();
    }

    @Override
    public void setPaid() {
        this.paid = true;
    }

    @Override
    public UUID getId() {
        return this.id;
    }
}

