/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.Costs;
import mage.abilities.costs.VariableCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.VariableManaCost;
import mage.game.Game;
import mage.target.Targets;

public class CostsImpl<T extends Cost>
extends ArrayList<T>
implements Costs<T> {
    protected String text = null;

    public CostsImpl() {
    }

    protected CostsImpl(CostsImpl<T> costs) {
        this.ensureCapacity(costs.size());
        for (Cost cost : costs) {
            this.add(cost.copy());
        }
        this.text = costs.text;
    }

    @Override
    public UUID getId() {
        throw new RuntimeException("Not supported method");
    }

    @Override
    public CostsImpl<T> setText(String text) {
        this.text = text;
        return this;
    }

    @Override
    public String getText() {
        if (this.text != null) {
            return this.text;
        }
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder sbText = new StringBuilder();
        for (Cost cost : this) {
            String textCost = cost.getText();
            if (textCost == null || textCost.isEmpty()) continue;
            if (textCost.startsWith("and")) {
                if (sbText.length() > 1) {
                    sbText.deleteCharAt(sbText.length() - 2);
                }
                sbText.append(textCost).append(", ");
                continue;
            }
            sbText.append(Character.toUpperCase(textCost.charAt(0))).append(textCost.substring(1)).append(", ");
        }
        if (sbText.length() > 1) {
            sbText.setLength(sbText.length() - 2);
        }
        return sbText.toString();
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        for (Cost cost : this) {
            if (cost.canPay(ability, source, controllerId, game)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana) {
        return this.pay(ability, game, source, controllerId, noMana, this);
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        if (this.size() > 0) {
            while (!this.isPaid()) {
                T cost = this.getFirstUnpaid();
                if (cost.pay(ability, game, source, controllerId, noMana, costToPay)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isPaid() {
        for (Cost cost : this) {
            if (cost instanceof VariableManaCost || cost.isPaid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clearPaid() {
        for (Cost cost : this) {
            cost.clearPaid();
        }
    }

    @Override
    public void setPaid() {
        for (Cost cost : this) {
            cost.setPaid();
        }
    }

    @Override
    public Costs<T> getUnpaid() {
        CostsImpl<T> unpaid = new CostsImpl<T>();
        for (Cost cost : this) {
            if (cost.isPaid()) continue;
            unpaid.add(cost);
        }
        return unpaid;
    }

    protected T getFirstUnpaid() {
        List unpaid = this.getUnpaid();
        if (!unpaid.isEmpty()) {
            return (T)((Cost)unpaid.get(0));
        }
        return null;
    }

    @Override
    public List<VariableCost> getVariableCosts() {
        ArrayList<VariableCost> variableCosts = new ArrayList<VariableCost>();
        for (Cost cost : this) {
            if (cost instanceof VariableCost) {
                variableCosts.add((VariableCost)((Object)cost));
            }
            if (!(cost instanceof ManaCosts)) continue;
            variableCosts.addAll(((ManaCosts)cost).getVariableCosts());
        }
        return variableCosts;
    }

    @Override
    public Targets getTargets() {
        Targets res = new Targets();
        for (Cost cost : this) {
            res.addAll(cost.getTargets());
        }
        return res.withReadOnly();
    }

    @Override
    public CostsImpl<T> copy() {
        return new CostsImpl<T>(this);
    }
}

