/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.common;

import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.cards.Card;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

public class CyclingDiscardCost
extends CostImpl {
    private MageObjectReference cycledCard = null;

    public CyclingDiscardCost() {
    }

    private CyclingDiscardCost(CyclingDiscardCost cost) {
        super(cost);
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return game.getPlayer(controllerId).getHand().contains(source.getSourceId());
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Card card;
        Player player = game.getPlayer(controllerId);
        if (player != null && (card = player.getHand().get(source.getSourceId(), game)) != null) {
            game.fireEvent(GameEvent.getEvent(GameEvent.EventType.CYCLE_CARD, card.getId(), source, card.getOwnerId()));
            this.paid = player.discard(card, true, source, game);
            if (this.paid) {
                this.cycledCard = new MageObjectReference(card, game);
                game.fireEvent(GameEvent.getEvent(GameEvent.EventType.CYCLED_CARD, card.getId(), source, card.getOwnerId()));
            }
        }
        return this.paid;
    }

    @Override
    public String getText() {
        return "Discard this card";
    }

    @Override
    public CyclingDiscardCost copy() {
        return new CyclingDiscardCost(this);
    }

    public MageObjectReference getCycledCard() {
        return this.cycledCard;
    }
}

