/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

public class ExileSourceFromGraveCost
extends CostImpl {
    public ExileSourceFromGraveCost() {
        this.text = "exile this card from your graveyard";
    }

    private ExileSourceFromGraveCost(ExileSourceFromGraveCost cost) {
        super(cost);
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player controller = game.getPlayer(controllerId);
        if (controller == null) {
            return this.paid;
        }
        Card card = game.getCard(source.getSourceId());
        if (card != null && game.getState().getZone(source.getSourceId()) == Zone.GRAVEYARD) {
            controller.moveCards(card, Zone.EXILED, source, game);
            this.paid = true;
        }
        return this.paid;
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return game.getCard(source.getSourceId()) != null && game.getState().getZone(source.getSourceId()) == Zone.GRAVEYARD;
    }

    @Override
    public ExileSourceFromGraveCost copy() {
        return new ExileSourceFromGraveCost(this);
    }
}

