/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.common;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.cards.Card;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class MillCardsCost
extends CostImpl {
    private final int numberOfCards;
    private final Set<Card> cardsMovedToGraveyard = new LinkedHashSet<Card>();

    public MillCardsCost() {
        this(1);
    }

    public MillCardsCost(int numberOfCards) {
        this.numberOfCards = numberOfCards;
        this.text = this.setText();
    }

    private MillCardsCost(MillCardsCost cost) {
        super(cost);
        this.numberOfCards = cost.numberOfCards;
        this.cardsMovedToGraveyard.addAll(cost.getCardsMovedToGraveyard());
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player player = game.getPlayer(controllerId);
        if (player != null && player.getLibrary().size() >= this.numberOfCards) {
            this.paid = true;
            this.cardsMovedToGraveyard.addAll(player.millCards(this.numberOfCards, ability, game).getCards(game));
        }
        return this.paid;
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        Player player = game.getPlayer(controllerId);
        return player != null && player.getLibrary().size() >= this.numberOfCards;
    }

    @Override
    public MillCardsCost copy() {
        return new MillCardsCost(this);
    }

    public Set<Card> getCardsMovedToGraveyard() {
        return this.cardsMovedToGraveyard;
    }

    private String setText() {
        return "mill " + (this.numberOfCards == 1 ? "a card" : CardUtil.numberToText(this.numberOfCards) + " cards");
    }
}

