/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class PayLifeCost
extends CostImpl {
    private final DynamicValue amount;
    private int lifePaid = 0;

    public PayLifeCost(int amount) {
        this(StaticValue.get(amount), Integer.toString(amount) + " life");
    }

    public PayLifeCost(DynamicValue amount, String text) {
        this.amount = amount.copy();
        this.text = "pay " + text;
    }

    protected PayLifeCost(PayLifeCost cost) {
        super(cost);
        this.amount = cost.amount.copy();
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        Player player = game.getPlayer(controllerId);
        if (player == null) {
            return false;
        }
        int lifeToPayAmount = this.amount.calculate(game, ability, null);
        if (lifeToPayAmount > 0 && !player.canPayLifeCost(ability)) {
            return false;
        }
        return player.getLife() >= lifeToPayAmount || lifeToPayAmount == 0;
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player controller = game.getPlayer(controllerId);
        if (controller == null) {
            return false;
        }
        int lifeToPayAmount = this.amount.calculate(game, ability, null);
        this.paid = CardUtil.tryPayLife(lifeToPayAmount, controller, source, game);
        this.lifePaid = lifeToPayAmount;
        return this.paid;
    }

    @Override
    public PayLifeCost copy() {
        return new PayLifeCost(this);
    }

    @Override
    public void clearPaid() {
        super.clearPaid();
        this.lifePaid = 0;
    }

    public int getLifePaid() {
        return this.lifePaid;
    }
}

