/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.common;

import java.util.LinkedHashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.cards.Card;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.TargetPermanent;
import mage.util.CardUtil;

public class RemoveCounterCost
extends CostImpl {
    protected final Target target;
    private final CounterType counterTypeToRemove;
    protected final int countersToRemove;

    public RemoveCounterCost(Target target) {
        this(target, null);
    }

    public RemoveCounterCost(Target target, CounterType counterTypeToRemove) {
        this(target, counterTypeToRemove, 1);
    }

    public RemoveCounterCost(Target target, CounterType counterTypeToRemove, int countersToRemove) {
        this.target = target.withNotTarget(true);
        this.counterTypeToRemove = counterTypeToRemove;
        this.countersToRemove = countersToRemove;
        this.text = this.setText();
    }

    protected RemoveCounterCost(RemoveCounterCost cost) {
        super(cost);
        this.target = cost.target.copy();
        this.countersToRemove = cost.countersToRemove;
        this.counterTypeToRemove = cost.counterTypeToRemove;
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Outcome outcome;
        this.paid = false;
        int countersRemoved = 0;
        Player controller = game.getPlayer(controllerId);
        if (controller == null) {
            return false;
        }
        if (this.countersToRemove == 0) {
            this.paid = true;
            return this.paid;
        }
        this.target.clearChosen();
        if (this.target instanceof TargetPermanent) {
            outcome = Outcome.AIDontUseIt;
        } else if (this.target instanceof TargetCard) {
            outcome = Outcome.Neutral;
        } else {
            throw new IllegalArgumentException("Wrong target type provided for RemoveCounterCost. Provided " + this.target.getClass() + ". From ability " + ability);
        }
        if (!this.target.choose(outcome, controllerId, source.getSourceId(), source, game)) {
            return this.paid;
        }
        for (UUID targetId : this.target.getTargets()) {
            Card targetObject = this.target instanceof TargetPermanent ? game.getPermanent(targetId) : game.getCard(targetId);
            if (targetObject == null || targetObject.getCounters(game).isEmpty() || this.counterTypeToRemove != null && !targetObject.getCounters(game).containsKey(this.counterTypeToRemove)) continue;
            String counterName = null;
            if (this.counterTypeToRemove != null) {
                counterName = this.counterTypeToRemove.getName();
            } else if (targetObject.getCounters(game).size() == 1) {
                for (Counter counter : targetObject.getCounters(game).values()) {
                    if (counter.getCount() <= 0) continue;
                    counterName = counter.getName();
                }
            } else {
                ChoiceImpl choice = new ChoiceImpl(true);
                LinkedHashSet<String> choices = new LinkedHashSet<String>();
                for (Counter counter : targetObject.getCounters(game).values()) {
                    if (targetObject.getCounters(game).getCount(counter.getName()) <= 0) continue;
                    choices.add(counter.getName());
                }
                choice.setChoices(choices);
                choice.setMessage("Choose a counter to remove from " + targetObject.getLogName());
                if (!controller.choose(outcome, choice, game)) {
                    return false;
                }
                counterName = choice.getChoice();
            }
            if (counterName == null || counterName.isEmpty()) continue;
            int countersLeft = this.countersToRemove - countersRemoved;
            int countersOnPermanent = targetObject.getCounters(game).getCount(counterName);
            int numberOfCountersSelected = 1;
            if (countersLeft > 1 && countersOnPermanent > 1) {
                numberOfCountersSelected = controller.getAmount(1, Math.min(countersLeft, countersOnPermanent), "Choose how many counters (" + counterName + ") to remove from " + targetObject.getLogName() + " as payment", source, game);
            }
            targetObject.removeCounters(counterName, numberOfCountersSelected, source, game);
            countersRemoved += numberOfCountersSelected;
            if (!game.isSimulation()) {
                game.informPlayers(controller.getLogName() + " removes " + (numberOfCountersSelected == 1 ? "a" : Integer.valueOf(numberOfCountersSelected)) + ' ' + counterName + (numberOfCountersSelected == 1 ? " counter from " : " counters from ") + targetObject.getName());
            }
            if (countersRemoved != this.countersToRemove) continue;
            this.paid = true;
            break;
        }
        return this.paid;
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return this.target.canChooseOrAlreadyChosen(controllerId, source, game);
    }

    private String setText() {
        StringBuilder sb = new StringBuilder("remove ");
        if (this.counterTypeToRemove != null) {
            sb.append(CardUtil.numberToText(this.countersToRemove, this.counterTypeToRemove.getArticle()));
            sb.append(' ');
            sb.append(this.counterTypeToRemove.getName());
        } else {
            sb.append(CardUtil.numberToText(this.countersToRemove, "a"));
        }
        sb.append(this.countersToRemove > 1 ? " counters from " : " counter from ");
        if (this.target.getMaxNumberOfTargets() > 1) {
            sb.append(this.target.getTargetName());
        } else {
            sb.append(CardUtil.addArticle(this.target.getTargetName()));
        }
        return sb.toString();
    }

    @Override
    public RemoveCounterCost copy() {
        return new RemoveCounterCost(this);
    }
}

