/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.common;

import java.util.UUID;
import java.util.stream.IntStream;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.VariableCostImpl;
import mage.abilities.costs.VariableCostType;
import mage.abilities.costs.common.RemoveCounterCost;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.target.TargetPermanent;
import mage.util.CardUtil;

public class RemoveVariableCountersTargetCost
extends VariableCostImpl {
    protected final FilterPermanent filter;
    protected final CounterType counterTypeToRemove;
    protected final int minValue;
    protected final boolean onlyOne;

    public RemoveVariableCountersTargetCost(FilterPermanent filter) {
        this(filter, null);
    }

    public RemoveVariableCountersTargetCost(FilterPermanent filter, CounterType counterTypeToRemove) {
        this(filter, counterTypeToRemove, "X", 0);
    }

    public RemoveVariableCountersTargetCost(FilterPermanent filter, CounterType counterTypeToRemove, String xText, int minValue) {
        this(filter, counterTypeToRemove, xText, minValue, null);
    }

    public RemoveVariableCountersTargetCost(FilterPermanent filter, CounterType counterTypeToRemove, String xText, int minValue, String text) {
        this(filter, counterTypeToRemove, xText, minValue, false, text);
    }

    public RemoveVariableCountersTargetCost(FilterPermanent filter, CounterType counterTypeToRemove, String xText, int minValue, boolean onlyOne, String text) {
        super(VariableCostType.NORMAL, xText, (counterTypeToRemove != null ? counterTypeToRemove.getName() + ' ' : "") + "counters to remove");
        this.filter = filter;
        this.counterTypeToRemove = counterTypeToRemove;
        this.minValue = minValue;
        this.onlyOne = onlyOne;
        this.text = text != null && !text.isEmpty() ? text : this.setText();
    }

    protected RemoveVariableCountersTargetCost(RemoveVariableCountersTargetCost cost) {
        super(cost);
        this.filter = cost.filter;
        this.counterTypeToRemove = cost.counterTypeToRemove;
        this.minValue = cost.minValue;
        this.onlyOne = cost.onlyOne;
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        return this.paid;
    }

    private String setText() {
        StringBuilder sb = new StringBuilder("Remove ");
        sb.append(this.xText);
        if (this.counterTypeToRemove != null) {
            sb.append(' ');
            sb.append(this.counterTypeToRemove.getName());
        }
        sb.append(" counters from ");
        if (this.onlyOne) {
            sb.append(CardUtil.addArticle(this.filter.getMessage()));
        } else {
            sb.append("among ");
            sb.append(this.filter.getMessage());
        }
        return sb.toString();
    }

    @Override
    public RemoveVariableCountersTargetCost copy() {
        return new RemoveVariableCountersTargetCost(this);
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return this.getMaxValue(source, game) >= this.minValue;
    }

    @Override
    public int getMinValue(Ability source, Game game) {
        return this.minValue;
    }

    @Override
    public int getMaxValue(Ability source, Game game) {
        IntStream stream = game.getBattlefield().getAllActivePermanents(this.filter, source.getControllerId(), game).stream().map(permanent -> permanent.getCounters(game)).mapToInt(counters -> this.counterTypeToRemove == null ? counters.values().stream().mapToInt(Counter::getCount).sum() : counters.getCount(this.counterTypeToRemove));
        if (this.onlyOne) {
            return stream.max().orElse(0);
        }
        return stream.sum();
    }

    @Override
    public Cost getFixedCostsFromAnnouncedValue(int xValue) {
        return new RemoveCounterCost(new TargetPermanent(this.minValue, this.onlyOne ? 1 : Integer.MAX_VALUE, this.filter, true), this.counterTypeToRemove, xValue);
    }
}

