/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.common;

import java.util.LinkedHashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

public class ReturnToHandFromGraveyardCost
extends CostImpl {
    public ReturnToHandFromGraveyardCost(TargetCardInYourGraveyard target) {
        this.addTarget(target);
        this.text = "return " + target.getDescription() + " from your graveyard to your hand";
    }

    public ReturnToHandFromGraveyardCost(ReturnToHandFromGraveyardCost cost) {
        super(cost);
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player controller = game.getPlayer(controllerId);
        if (controller != null && this.getTargets().choose(Outcome.ReturnToHand, controllerId, source.getSourceId(), source, game)) {
            LinkedHashSet<Card> cardsToMove = new LinkedHashSet<Card>();
            for (UUID targetId : ((Target)this.getTargets().get(0)).getTargets()) {
                Card targetCard = game.getCard(targetId);
                if (targetCard == null) {
                    return false;
                }
                cardsToMove.add(targetCard);
            }
            controller.moveCards(cardsToMove, Zone.HAND, ability, game);
            this.paid = true;
        }
        return this.paid;
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return this.canChooseOrAlreadyChosen(ability, source, controllerId, game);
    }

    @Override
    public ReturnToHandFromGraveyardCost copy() {
        return new ReturnToHandFromGraveyardCost(this);
    }
}

