/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.abilities.costs.SacrificeCost;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class SacrificeSourceCost
extends CostImpl
implements SacrificeCost {
    public SacrificeSourceCost() {
        this.text = "sacrifice {this}";
    }

    public SacrificeSourceCost(SacrificeSourceCost cost) {
        super(cost);
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null) {
            this.paid = permanent.sacrifice(source, game);
        }
        return this.paid;
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        return permanent != null && game.getPlayer(controllerId).canPaySacrificeCost(permanent, source, controllerId, game);
    }

    @Override
    public SacrificeSourceCost copy() {
        return new SacrificeSourceCost(this);
    }
}

