/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.common;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.constants.Outcome;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.common.TargetControlledPermanent;
import mage.util.CardUtil;

public class TapTargetCost
extends CostImpl {
    TargetControlledPermanent target;

    public TapTargetCost(FilterControlledPermanent filter) {
        this(1, filter);
    }

    public TapTargetCost(int amount, FilterControlledPermanent filter) {
        this(amount, amount, filter);
    }

    public TapTargetCost(int minAmount, int maxAmount, FilterControlledPermanent filter) {
        this(new TargetControlledPermanent(minAmount, maxAmount, filter, true));
    }

    public TapTargetCost(TargetControlledPermanent target) {
        this.target = target;
        this.target.withNotTarget(true);
        this.target.setRequired(false);
        this.text = "tap " + (target.getMinNumberOfTargets() > 1 ? CardUtil.numberToText(target.getMaxNumberOfTargets()) + ' ' + target.getTargetName() : CardUtil.addArticle(target.getTargetName()));
    }

    protected TapTargetCost(TapTargetCost cost) {
        super(cost);
        this.target = cost.target.copy();
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        ArrayList<Permanent> permanents = new ArrayList<Permanent>();
        if (this.target.getMaxNumberOfTargets() > 0 && this.target.choose(Outcome.Tap, controllerId, source.getSourceId(), source, game)) {
            for (UUID targetId : this.target.getTargets()) {
                Permanent permanent = game.getPermanent(targetId);
                if (permanent == null) {
                    return false;
                }
                this.paid |= permanent.tap(source, game);
                permanents.add(permanent);
            }
        }
        if (this.target.getMinNumberOfTargets() == 0) {
            this.paid = true;
        }
        source.getEffects().setValue("tappedPermanents", permanents);
        return this.paid;
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return this.target.canChooseOrAlreadyChosen(controllerId, source, game);
    }

    public TargetControlledPermanent getTarget() {
        return this.target;
    }

    @Override
    public TapTargetCost copy() {
        return new TapTargetCost(this);
    }
}

