/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.UseAttachedCost;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class UnattachCost
extends UseAttachedCost {
    public UnattachCost() {
    }

    protected UnattachCost(UnattachCost cost) {
        super(cost);
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        if (this.mageObjectReference == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null) {
            return this.paid;
        }
        for (UUID attachmentId : permanent.getAttachments()) {
            if (!this.mageObjectReference.refersTo(attachmentId, game)) continue;
            this.paid = permanent.removeAttachment(attachmentId, source, game);
            if (!this.paid) continue;
            break;
        }
        return this.paid;
    }

    @Override
    public UnattachCost copy() {
        return new UnattachCost(this);
    }

    @Override
    public String getText() {
        return "unattach " + this.name;
    }
}

