/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.mana;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostImpl;
import mage.constants.ColoredManaSymbol;
import mage.game.Game;
import mage.players.ManaPool;

public class ColorlessManaCost
extends ManaCostImpl {
    protected int mana;

    public ColorlessManaCost(int mana) {
        this.mana = mana;
        this.cost = Mana.ColorlessMana(mana);
        this.options.addMana(Mana.ColorlessMana(mana));
    }

    public ColorlessManaCost(ColorlessManaCost manaCost) {
        super(manaCost);
        this.mana = manaCost.mana;
    }

    public void setMana(int mana) {
        this.mana = mana;
    }

    @Override
    public int manaValue() {
        return this.mana;
    }

    @Override
    public boolean isPaid() {
        if (this.paid) {
            return true;
        }
        return this.isColorlessPaid(this.mana);
    }

    @Override
    public void assignPayment(Game game, Ability ability, ManaPool pool, Cost costToPay) {
        this.assignColorless(ability, game, pool, this.mana, costToPay);
    }

    @Override
    public String getText() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.mana; ++i) {
            sb.append("{C}");
        }
        return sb.toString();
    }

    @Override
    public ColorlessManaCost getUnpaid() {
        ColorlessManaCost unpaid = new ColorlessManaCost(this.mana - this.payment.count());
        if (this.sourceFilter != null) {
            unpaid.setSourceFilter(this.sourceFilter);
        }
        return unpaid;
    }

    @Override
    public boolean testPay(Mana testMana) {
        return testMana.getColorless() > 0;
    }

    @Override
    public ColorlessManaCost copy() {
        return new ColorlessManaCost(this);
    }

    @Override
    public boolean containsColor(ColoredManaSymbol coloredManaSymbol) {
        return false;
    }
}

