/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.mana;

import java.util.ArrayList;
import java.util.List;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostImpl;
import mage.constants.ColoredManaSymbol;
import mage.game.Game;
import mage.players.ManaPool;

public class HybridManaCost
extends ManaCostImpl {
    private final ColoredManaSymbol mana1;
    private final ColoredManaSymbol mana2;

    public HybridManaCost(ColoredManaSymbol mana1, ColoredManaSymbol mana2) {
        this.mana1 = mana1;
        this.mana2 = mana2;
        this.cost = mana1 == null ? Mana.ColorlessMana(1) : new Mana(mana1);
        this.cost.add(new Mana(mana2));
        this.addColoredOption(mana1);
        this.addColoredOption(mana2);
    }

    public HybridManaCost(HybridManaCost manaCost) {
        super(manaCost);
        this.mana1 = manaCost.mana1;
        this.mana2 = manaCost.mana2;
    }

    @Override
    public int manaValue() {
        return 1;
    }

    @Override
    public boolean isPaid() {
        return this.paid || this.isColoredPaid(this.mana1) || this.isColoredPaid(this.mana2);
    }

    @Override
    public void assignPayment(Game game, Ability ability, ManaPool pool, Cost costToPay) {
        if (this.mana1 != null && this.assignColored(ability, game, pool, this.mana1, costToPay)) {
            return;
        }
        this.assignColored(ability, game, pool, this.mana2, costToPay);
    }

    @Override
    public String getText() {
        return '{' + this.mana1.toString() + '/' + this.mana2.toString() + (this.phyrexian ? "/P" : "") + '}';
    }

    @Override
    public HybridManaCost getUnpaid() {
        return this;
    }

    @Override
    public boolean testPay(Mana testMana) {
        switch (this.mana1) {
            case B: {
                if (testMana.getBlack() > 0 || testMana.getAny() > 0) {
                    return true;
                }
            }
            case U: {
                if (testMana.getBlue() > 0 || testMana.getAny() > 0) {
                    return true;
                }
            }
            case R: {
                if (testMana.getRed() > 0 || testMana.getAny() > 0) {
                    return true;
                }
            }
            case W: {
                if (testMana.getWhite() > 0 || testMana.getAny() > 0) {
                    return true;
                }
            }
            case G: {
                if (testMana.getGreen() <= 0 && testMana.getAny() <= 0) break;
                return true;
            }
        }
        if (testMana.getColorless() > 0) {
            return true;
        }
        switch (this.mana2) {
            case B: {
                return testMana.getBlack() > 0 || testMana.getAny() > 0;
            }
            case U: {
                return testMana.getBlue() > 0 || testMana.getAny() > 0;
            }
            case R: {
                return testMana.getRed() > 0 || testMana.getAny() > 0;
            }
            case W: {
                return testMana.getWhite() > 0 || testMana.getAny() > 0;
            }
            case G: {
                return testMana.getGreen() > 0 || testMana.getAny() > 0;
            }
        }
        return false;
    }

    @Override
    public HybridManaCost copy() {
        return new HybridManaCost(this);
    }

    @Override
    public boolean containsColor(ColoredManaSymbol coloredManaSymbol) {
        return this.mana1 == coloredManaSymbol || this.mana2 == coloredManaSymbol;
    }

    @Override
    public List<Mana> getManaOptions() {
        ArrayList<Mana> manaList = new ArrayList<Mana>();
        manaList.add(new Mana(this.mana1));
        manaList.add(new Mana(this.mana2));
        return manaList;
    }

    public ColoredManaSymbol getMana1() {
        return this.mana1;
    }

    public ColoredManaSymbol getMana2() {
        return this.mana2;
    }
}

