/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.mana;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.mana.ManaOptions;
import mage.constants.ColoredManaSymbol;
import mage.constants.ManaType;
import mage.filter.Filter;
import mage.filter.FilterMana;
import mage.game.Game;
import mage.players.ManaPool;
import mage.players.Player;
import mage.util.ManaUtil;

public abstract class ManaCostImpl
extends CostImpl
implements ManaCost {
    protected Mana payment;
    protected Mana usedManaToPay;
    protected Mana cost;
    protected ManaOptions options;
    protected Filter sourceFilter;
    protected boolean phyrexian = false;

    public ManaCostImpl() {
        this.payment = new Mana();
        this.usedManaToPay = new Mana();
        this.options = new ManaOptions();
    }

    protected ManaCostImpl(ManaCostImpl manaCost) {
        super(manaCost);
        this.payment = manaCost.payment.copy();
        this.usedManaToPay = manaCost.usedManaToPay.copy();
        this.cost = manaCost.cost.copy();
        this.options = manaCost.options.copy();
        if (manaCost.sourceFilter != null) {
            this.sourceFilter = manaCost.sourceFilter.copy();
        }
        this.phyrexian = manaCost.phyrexian;
    }

    @Override
    public abstract ManaCostImpl copy();

    @Override
    public Mana getPayment() {
        return this.payment;
    }

    @Override
    public Mana getUsedManaToPay() {
        return this.usedManaToPay;
    }

    @Override
    public Mana getMana() {
        return this.cost;
    }

    @Override
    public List<Mana> getManaOptions() {
        ArrayList<Mana> manaList = new ArrayList<Mana>();
        manaList.add(this.cost);
        return manaList;
    }

    @Override
    public final ManaOptions getOptions() {
        return this.getOptions(true);
    }

    @Override
    public ManaOptions getOptions(boolean canPayLifeCost) {
        if (!canPayLifeCost && this.isPhyrexian()) {
            ManaOptions optionsFiltered = new ManaOptions();
            optionsFiltered.add(this.cost);
            return optionsFiltered;
        }
        return this.options;
    }

    @Override
    public void clearPaid() {
        super.clearPaid();
        this.payment.clear();
        this.usedManaToPay.clear();
    }

    @Override
    public Filter getSourceFilter() {
        return this.sourceFilter;
    }

    @Override
    public void setSourceFilter(Filter filter) {
        this.sourceFilter = filter;
    }

    protected boolean assignColored(Ability ability, Game game, ManaPool pool, ColoredManaSymbol mana, Cost costToPay) {
        switch (mana) {
            case W: {
                if (!pool.pay(ManaType.WHITE, ability, this.sourceFilter, game, costToPay, this.usedManaToPay)) break;
                this.payment.increaseWhite();
                return true;
            }
            case U: {
                if (!pool.pay(ManaType.BLUE, ability, this.sourceFilter, game, costToPay, this.usedManaToPay)) break;
                this.payment.increaseBlue();
                return true;
            }
            case B: {
                if (!pool.pay(ManaType.BLACK, ability, this.sourceFilter, game, costToPay, this.usedManaToPay)) break;
                this.payment.increaseBlack();
                return true;
            }
            case R: {
                if (!pool.pay(ManaType.RED, ability, this.sourceFilter, game, costToPay, this.usedManaToPay)) break;
                this.payment.increaseRed();
                return true;
            }
            case G: {
                if (!pool.pay(ManaType.GREEN, ability, this.sourceFilter, game, costToPay, this.usedManaToPay)) break;
                this.payment.increaseGreen();
                return true;
            }
        }
        return false;
    }

    protected boolean assignColorless(Ability ability, Game game, ManaPool pool, int mana, Cost costToPay) {
        int conditionalCount = pool.getConditionalCount(ability, game, null, costToPay);
        if (mana > this.payment.count() && (pool.count() > 0 || conditionalCount > 0) && pool.pay(ManaType.COLORLESS, ability, this.sourceFilter, game, costToPay, this.usedManaToPay)) {
            this.payment.increaseColorless();
            return true;
        }
        return false;
    }

    protected boolean assignGeneric(Ability ability, Game game, ManaPool pool, int mana, FilterMana filterMana, Cost costToPay) {
        int conditionalCount = pool.getConditionalCount(ability, game, filterMana, costToPay);
        while (mana > this.payment.count() && (pool.count() > 0 || conditionalCount > 0)) {
            if ((filterMana == null || filterMana.isColorless()) && pool.pay(ManaType.COLORLESS, ability, this.sourceFilter, game, costToPay, this.usedManaToPay)) {
                this.payment.increaseColorless();
                continue;
            }
            if ((filterMana == null || filterMana.isBlack()) && pool.pay(ManaType.BLACK, ability, this.sourceFilter, game, costToPay, this.usedManaToPay)) {
                this.payment.increaseBlack();
                continue;
            }
            if ((filterMana == null || filterMana.isBlue()) && pool.pay(ManaType.BLUE, ability, this.sourceFilter, game, costToPay, this.usedManaToPay)) {
                this.payment.increaseBlue();
                continue;
            }
            if ((filterMana == null || filterMana.isWhite()) && pool.pay(ManaType.WHITE, ability, this.sourceFilter, game, costToPay, this.usedManaToPay)) {
                this.payment.increaseWhite();
                continue;
            }
            if ((filterMana == null || filterMana.isGreen()) && pool.pay(ManaType.GREEN, ability, this.sourceFilter, game, costToPay, this.usedManaToPay)) {
                this.payment.increaseGreen();
                continue;
            }
            if (filterMana != null && !filterMana.isRed() || !pool.pay(ManaType.RED, ability, this.sourceFilter, game, costToPay, this.usedManaToPay)) break;
            this.payment.increaseRed();
        }
        return mana > this.payment.count();
    }

    protected boolean isColoredPaid(ColoredManaSymbol mana) {
        switch (mana) {
            case B: {
                return this.payment.getBlack() > 0;
            }
            case U: {
                return this.payment.getBlue() > 0;
            }
            case W: {
                return this.payment.getWhite() > 0;
            }
            case G: {
                return this.payment.getGreen() > 0;
            }
            case R: {
                return this.payment.getRed() > 0;
            }
        }
        return false;
    }

    protected boolean isColorlessPaid(int mana) {
        return this.payment.count() >= mana;
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return true;
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        if (noMana) {
            this.setPaid();
            return true;
        }
        Player player = game.getPlayer(controllerId);
        if (player == null) {
            return false;
        }
        if (!player.getManaPool().isForcedToPay()) {
            this.assignPayment(game, ability, player.getManaPool(), costToPay != null ? costToPay : this);
        }
        game.getState().getSpecialActions().removeManaActions();
        while (player.canRespond() && !this.isPaid()) {
            String promptText;
            ManaCost unpaid = this.getUnpaid();
            if (!player.playMana(ability, unpaid, promptText = ManaUtil.addSpecialManaPayAbilities(ability, game, unpaid), game)) {
                return false;
            }
            this.assignPayment(game, ability, player.getManaPool(), costToPay != null ? costToPay : this);
            game.getState().getSpecialActions().removeManaActions();
        }
        return this.isPaid();
    }

    @Override
    public void setPaid() {
        this.paid = true;
    }

    @Override
    public void setPayment(Mana mana) {
        this.payment.add(mana);
    }

    protected void addColoredOption(ColoredManaSymbol symbol) {
        switch (symbol) {
            case B: {
                this.options.add(Mana.BlackMana(1));
                return;
            }
            case U: {
                this.options.add(Mana.BlueMana(1));
                return;
            }
            case W: {
                this.options.add(Mana.WhiteMana(1));
                return;
            }
            case R: {
                this.options.add(Mana.RedMana(1));
                return;
            }
            case G: {
                this.options.add(Mana.GreenMana(1));
                return;
            }
        }
        this.options.add(Mana.ColorlessMana(1));
    }

    public String toString() {
        return this.getText();
    }

    @Override
    public boolean isPhyrexian() {
        return this.phyrexian;
    }

    @Override
    public void setPhyrexian(boolean phyrexian) {
        if (phyrexian) {
            this.options.add(Mana.GenericMana(0));
        }
        this.phyrexian = phyrexian;
    }
}

