/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.decorator;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.condition.Condition;
import mage.abilities.condition.FixedCondition;
import mage.abilities.condition.LockedInCondition;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.EffectType;
import mage.constants.Layer;
import mage.constants.SubLayer;
import mage.game.Game;

public class ConditionalContinuousEffect
extends ContinuousEffectImpl {
    protected ContinuousEffect effect;
    protected ContinuousEffect otherwiseEffect;
    protected Condition baseCondition;
    protected Condition condition;
    protected boolean initDone = false;

    public ConditionalContinuousEffect(ContinuousEffect effect, Condition condition, String text) {
        this(effect, null, condition, text);
    }

    public ConditionalContinuousEffect(ContinuousEffect effect, ContinuousEffect otherwiseEffect, Condition condition, String text) {
        super(effect.getDuration(), effect.getLayer(), effect.getSublayer(), effect.getOutcome());
        this.effect = effect;
        this.otherwiseEffect = otherwiseEffect;
        this.baseCondition = condition;
        this.staticText = text;
        EffectType needType = EffectType.CONTINUOUS;
        if (effect.getEffectType() != needType) {
            throw new IllegalArgumentException("ConditionalContinuousEffect supports only " + (Object)((Object)needType) + " but found " + effect.getEffectType().toString());
        }
        if (otherwiseEffect != null && otherwiseEffect.getEffectType() != needType) {
            throw new IllegalArgumentException("ConditionalContinuousEffect supports only " + needType.toString() + " but found " + effect.getEffectType().toString());
        }
        if (otherwiseEffect != null && effect.getEffectType() != otherwiseEffect.getEffectType()) {
            throw new IllegalArgumentException("ConditionalContinuousEffect must be same but found " + effect.getEffectType().toString() + " and " + otherwiseEffect.getEffectType().toString());
        }
    }

    protected ConditionalContinuousEffect(ConditionalContinuousEffect effect) {
        super(effect);
        this.effect = effect.effect.copy();
        if (effect.otherwiseEffect != null) {
            this.otherwiseEffect = effect.otherwiseEffect.copy();
        }
        this.condition = effect.condition;
        this.baseCondition = effect.baseCondition;
        this.initDone = effect.initDone;
    }

    @Override
    public boolean isDiscarded() {
        return this.discarded || this.effect.isDiscarded() || this.otherwiseEffect != null && this.otherwiseEffect.isDiscarded();
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        this.condition = this.baseCondition instanceof LockedInCondition ? new FixedCondition(((LockedInCondition)this.baseCondition).getBaseCondition().apply(game, source)) : this.baseCondition;
        this.effect.setTargetPointer(this.getTargetPointer().copy());
        this.effect.init(source, game);
        if (this.otherwiseEffect != null) {
            this.otherwiseEffect.setTargetPointer(this.getTargetPointer().copy());
            this.otherwiseEffect.init(source, game);
        }
        this.initDone = true;
    }

    @Override
    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        boolean conditionState;
        if (!this.initDone) {
            this.init(source, game);
        }
        if (conditionState = this.condition.apply(game, source)) {
            return this.effect.apply(layer, sublayer, source, game);
        }
        if (this.otherwiseEffect != null) {
            return this.otherwiseEffect.apply(layer, sublayer, source, game);
        }
        if (!conditionState && this.effect.getDuration() == Duration.OneUse) {
            this.used = true;
        }
        switch (this.effect.getDuration()) {
            case OneUse: {
                this.used = true;
                break;
            }
            case Custom: 
            case WhileControlled: {
                this.discard();
            }
        }
        return false;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        boolean conditionState;
        if (this.condition == null && this.baseCondition != null) {
            this.condition = this.baseCondition;
        }
        boolean bl = conditionState = this.condition != null && this.condition.apply(game, source);
        if (conditionState) {
            this.effect.setTargetPointer(this.getTargetPointer().copy());
            return this.effect.apply(game, source);
        }
        if (this.otherwiseEffect != null) {
            this.otherwiseEffect.setTargetPointer(this.getTargetPointer().copy());
            return this.otherwiseEffect.apply(game, source);
        }
        switch (this.effect.getDuration()) {
            case OneUse: {
                this.used = true;
                break;
            }
            case Custom: 
            case WhileControlled: {
                this.discard();
            }
        }
        return false;
    }

    @Override
    public String getText(Mode mode) {
        if ((this.staticText == null || this.staticText.isEmpty()) && this.effect != null) {
            return this.effect.getText(mode);
        }
        return this.staticText;
    }

    @Override
    public boolean hasLayer(Layer layer) {
        return this.effect.hasLayer(layer);
    }

    @Override
    public ConditionalContinuousEffect copy() {
        return new ConditionalContinuousEffect(this);
    }

    @Override
    public EnumSet<DependencyType> getDependencyTypes() {
        if (this.effect != null) {
            return this.effect.getDependencyTypes();
        }
        return super.getDependencyTypes();
    }

    @Override
    public EnumSet<DependencyType> getDependedToTypes() {
        if (this.effect != null) {
            return this.effect.getDependedToTypes();
        }
        return super.getDependedToTypes();
    }

    @Override
    public Set<UUID> isDependentTo(List<ContinuousEffect> allEffectsInLayer) {
        if (this.effect != null) {
            return this.effect.isDependentTo(allEffectsInLayer);
        }
        return super.isDependentTo(allEffectsInLayer);
    }

    public List<ContinuousEffect> getAllEffects() {
        ArrayList<ContinuousEffect> res = new ArrayList<ContinuousEffect>();
        if (this.effect != null) {
            res.add(this.effect);
        }
        if (this.otherwiseEffect != null) {
            res.add(this.otherwiseEffect);
        }
        return res;
    }

    @Override
    public Condition getCondition() {
        return this.condition == null ? this.baseCondition : this.condition;
    }
}

