/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.decorator;

import java.util.ArrayList;
import java.util.List;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.effects.mana.BasicManaEffect;
import mage.abilities.effects.mana.ManaEffect;
import mage.choices.ChoiceColor;
import mage.game.Game;
import mage.players.Player;

public class ConditionalManaEffect
extends ManaEffect {
    private final BasicManaEffect effect;
    private final BasicManaEffect otherwiseEffect;
    private final Condition condition;

    public ConditionalManaEffect(BasicManaEffect effect, BasicManaEffect otherwiseEffect, Condition condition, String text) {
        if (effect == null || otherwiseEffect == null) {
            throw new IllegalArgumentException("Wrong code usage: mana effect must not be null");
        }
        this.effect = effect;
        this.otherwiseEffect = otherwiseEffect;
        this.condition = condition;
        this.staticText = text;
    }

    public ConditionalManaEffect(ConditionalManaEffect effect) {
        super(effect);
        this.effect = effect.effect.copy();
        this.otherwiseEffect = effect.otherwiseEffect.copy();
        this.condition = effect.condition;
    }

    @Override
    public ConditionalManaEffect copy() {
        return new ConditionalManaEffect(this);
    }

    @Override
    public List<Mana> getNetMana(Game game, Ability source) {
        ArrayList<Mana> netMana = new ArrayList<Mana>();
        if (game != null) {
            if (this.condition.apply(game, source)) {
                return this.effect.getNetMana(game, source);
            }
            if (this.otherwiseEffect != null) {
                return this.otherwiseEffect.getNetMana(game, source);
            }
        }
        return netMana;
    }

    @Override
    public Mana produceMana(Game game, Ability source) {
        Mana mana = new Mana();
        if (game == null) {
            return mana;
        }
        mana = this.condition.apply(game, source) ? this.effect.getManaTemplate() : this.otherwiseEffect.getManaTemplate();
        if (mana.getAny() > 0) {
            int amount = mana.getAny();
            Player controller = game.getPlayer(source.getControllerId());
            if (controller == null) {
                return mana;
            }
            ChoiceColor choice = new ChoiceColor(true);
            if (controller.choose(this.outcome, choice, game)) {
                mana.setAny(0);
                mana.add(choice.getMana(amount));
            }
        }
        return mana;
    }

    @Override
    public Condition getCondition() {
        return this.condition;
    }
}

