/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.decorator;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.condition.FixedCondition;
import mage.abilities.condition.LockedInCondition;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class ConditionalRestrictionEffect
extends RestrictionEffect {
    protected RestrictionEffect effect;
    protected RestrictionEffect otherwiseEffect;
    protected Condition condition;
    protected boolean conditionState;
    protected Condition baseCondition;
    protected boolean initDone = false;

    public ConditionalRestrictionEffect(RestrictionEffect effect, Condition condition) {
        this(effect, condition, null);
    }

    public ConditionalRestrictionEffect(RestrictionEffect effect, Condition condition, String text) {
        this(effect.getDuration(), effect, condition, null, text);
    }

    public ConditionalRestrictionEffect(Duration duration, RestrictionEffect effect, Condition condition, RestrictionEffect otherwiseEffect) {
        this(duration, effect, condition, otherwiseEffect, null);
    }

    public ConditionalRestrictionEffect(Duration duration, RestrictionEffect effect, Condition condition, RestrictionEffect otherwiseEffect, String text) {
        super(duration);
        this.effect = effect;
        this.baseCondition = condition;
        this.otherwiseEffect = otherwiseEffect;
        if (text != null) {
            this.setText(text);
        }
    }

    protected ConditionalRestrictionEffect(ConditionalRestrictionEffect effect) {
        super(effect);
        this.effect = (RestrictionEffect)effect.effect.copy();
        if (effect.otherwiseEffect != null) {
            this.otherwiseEffect = (RestrictionEffect)effect.otherwiseEffect.copy();
        }
        this.condition = effect.condition;
        this.conditionState = effect.conditionState;
        this.baseCondition = effect.baseCondition;
        this.initDone = effect.initDone;
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        this.condition = this.baseCondition instanceof LockedInCondition ? new FixedCondition(((LockedInCondition)this.baseCondition).getBaseCondition().apply(game, source)) : this.baseCondition;
        this.effect.setTargetPointer(this.getTargetPointer().copy());
        this.effect.init(source, game);
        if (this.otherwiseEffect != null) {
            this.otherwiseEffect.setTargetPointer(this.getTargetPointer().copy());
            this.otherwiseEffect.init(source, game);
        }
        this.initDone = true;
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        if (!this.initDone) {
            this.init(source, game);
        }
        this.conditionState = this.condition.apply(game, source);
        if (this.conditionState) {
            this.effect.setTargetPointer(this.getTargetPointer().copy());
            return this.effect.applies(permanent, source, game);
        }
        if (this.otherwiseEffect != null) {
            this.otherwiseEffect.setTargetPointer(this.getTargetPointer().copy());
            return this.otherwiseEffect.applies(permanent, source, game);
        }
        if (this.effect.getDuration() == Duration.OneUse) {
            this.used = true;
        }
        if (this.effect.getDuration() == Duration.Custom) {
            this.discard();
        }
        return false;
    }

    @Override
    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        if (this.conditionState) {
            return this.effect.canAttack(game, canUseChooseDialogs);
        }
        if (this.otherwiseEffect != null) {
            return this.otherwiseEffect.canAttack(game, canUseChooseDialogs);
        }
        return true;
    }

    @Override
    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        if (this.conditionState) {
            return this.effect.canBlock(attacker, blocker, source, game, canUseChooseDialogs);
        }
        if (this.otherwiseEffect != null) {
            return this.otherwiseEffect.canBlock(attacker, blocker, source, game, canUseChooseDialogs);
        }
        return true;
    }

    @Override
    public boolean canBeBlocked(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        if (this.conditionState) {
            return this.effect.canBeBlocked(attacker, blocker, source, game, canUseChooseDialogs);
        }
        if (this.otherwiseEffect != null) {
            return this.otherwiseEffect.canBeBlocked(attacker, blocker, source, game, canUseChooseDialogs);
        }
        return true;
    }

    @Override
    public boolean canBeUntapped(Permanent permanent, Ability source, Game game, boolean canUseChooseDialogs) {
        if (this.conditionState) {
            return this.effect.canBeUntapped(permanent, source, game, canUseChooseDialogs);
        }
        if (this.otherwiseEffect != null) {
            return this.otherwiseEffect.canBeUntapped(permanent, source, game, canUseChooseDialogs);
        }
        return true;
    }

    @Override
    public boolean canUseActivatedAbilities(Permanent permanent, Ability source, Game game, boolean canUseChooseDialogs) {
        if (this.conditionState) {
            return this.effect.canUseActivatedAbilities(permanent, source, game, canUseChooseDialogs);
        }
        if (this.otherwiseEffect != null) {
            return this.otherwiseEffect.canUseActivatedAbilities(permanent, source, game, canUseChooseDialogs);
        }
        return true;
    }

    @Override
    public ConditionalRestrictionEffect copy() {
        return new ConditionalRestrictionEffect(this);
    }

    @Override
    public Condition getCondition() {
        return this.condition;
    }
}

