/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.dynamicvalue;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.game.Game;
import mage.util.CardUtil;

public class AdditiveDynamicValue
implements DynamicValue {
    private final List<DynamicValue> dynamicValues;

    public AdditiveDynamicValue(DynamicValue ... dynamicValues) {
        this(Arrays.asList(dynamicValues));
    }

    public AdditiveDynamicValue(List<DynamicValue> dynamicValues) {
        this.dynamicValues = new ArrayList<DynamicValue>(dynamicValues);
    }

    private AdditiveDynamicValue(AdditiveDynamicValue value) {
        this.dynamicValues = CardUtil.deepCopyObject(value.dynamicValues);
    }

    @Override
    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        return this.dynamicValues.stream().mapToInt(d -> d.calculate(game, sourceAbility, effect)).sum();
    }

    @Override
    public AdditiveDynamicValue copy() {
        return new AdditiveDynamicValue(this);
    }

    @Override
    public String getMessage() {
        return this.dynamicValues.stream().map(DynamicValue::getMessage).collect(Collectors.joining(" "));
    }
}

