/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.dynamicvalue;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.game.Game;

public class IntPlusDynamicValue
implements DynamicValue {
    private final DynamicValue value;
    private final int baseValue;

    public IntPlusDynamicValue(int baseValue, DynamicValue value) {
        this.value = value;
        this.baseValue = baseValue;
    }

    IntPlusDynamicValue(IntPlusDynamicValue dynamicValue) {
        this.value = dynamicValue.value;
        this.baseValue = dynamicValue.baseValue;
    }

    @Override
    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        return this.baseValue + this.value.calculate(game, sourceAbility, effect);
    }

    @Override
    public IntPlusDynamicValue copy() {
        return new IntPlusDynamicValue(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.baseValue).append(" plus ");
        return sb.append(this.value.toString()).toString();
    }

    @Override
    public String getMessage() {
        return this.value.getMessage();
    }

    @Override
    public int getSign() {
        return this.value.getSign();
    }
}

