/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.dynamicvalue;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.game.Game;

public class LimitedDynamicValue
implements DynamicValue {
    private final DynamicValue value;
    private final int limit;

    public LimitedDynamicValue(int limit, DynamicValue value) {
        this.value = value;
        this.limit = limit;
    }

    LimitedDynamicValue(LimitedDynamicValue dynamicValue) {
        this.value = dynamicValue.value;
        this.limit = dynamicValue.limit;
    }

    @Override
    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        return Math.min(this.limit, this.value.calculate(game, sourceAbility, effect));
    }

    @Override
    public LimitedDynamicValue copy() {
        return new LimitedDynamicValue(this);
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public String getMessage() {
        return this.value.getMessage();
    }

    @Override
    public int getSign() {
        return this.value.getSign();
    }
}

