/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.dynamicvalue.common;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.CardTypesInGraveyardHint;
import mage.abilities.effects.Effect;
import mage.abilities.hint.Hint;
import mage.cards.Card;
import mage.game.Game;
import mage.game.permanent.PermanentToken;
import mage.players.Player;

public enum CardTypesInGraveyardCount implements DynamicValue
{
    YOU("your graveyard"),
    ALL("all graveyards"),
    OPPONENTS("your opponents' graveyards");

    private final String message;
    private final CardTypesInGraveyardHint hint;

    private CardTypesInGraveyardCount(String message) {
        this.message = "the number of card types among cards in " + message;
        this.hint = new CardTypesInGraveyardHint(this);
    }

    @Override
    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        return this.getGraveyardCards(game, sourceAbility).map(card -> card.getCardType(game)).flatMap(Collection::stream).distinct().mapToInt(x -> 1).sum();
    }

    @Override
    public CardTypesInGraveyardCount copy() {
        return this;
    }

    public String toString() {
        return "X";
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public Hint getHint() {
        return this.hint;
    }

    public Stream<Card> getGraveyardCards(Game game, Ability ability) {
        Collection<UUID> playerIds;
        switch (this) {
            case YOU: {
                playerIds = Collections.singletonList(ability.getControllerId());
                break;
            }
            case OPPONENTS: {
                playerIds = game.getOpponents(ability.getControllerId());
                break;
            }
            case ALL: {
                playerIds = game.getState().getPlayersInRange(ability.getControllerId(), game);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong code usage: miss implementation for " + this);
            }
        }
        return playerIds.stream().map(game::getPlayer).filter(Objects::nonNull).map(Player::getGraveyard).map(graveyard -> graveyard.getCards(game)).flatMap(Collection::stream).filter(Objects::nonNull).filter(card -> !card.isCopy() && !(card instanceof PermanentToken));
    }
}

