/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.dynamicvalue.common;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.CardTypesInGraveyardCount;
import mage.abilities.hint.Hint;
import mage.cards.Card;
import mage.constants.CardType;
import mage.game.Game;

class CardTypesInGraveyardHint
implements Hint {
    CardTypesInGraveyardCount value;

    CardTypesInGraveyardHint(CardTypesInGraveyardCount value) {
        this.value = value;
    }

    private CardTypesInGraveyardHint(CardTypesInGraveyardHint hint) {
        this.value = hint.value;
    }

    @Override
    public String getText(Game game, Ability ability) {
        Stream<Card> stream = this.value.getGraveyardCards(game, ability);
        List types = stream.map(card -> card.getCardType(game)).flatMap(Collection::stream).distinct().map(CardType::toString).sorted().collect(Collectors.toList());
        return "Card types in " + this.value.getMessage() + ": " + types.size() + (types.size() > 0 ? " (" + String.join((CharSequence)", ", types) + ')' : "");
    }

    @Override
    public CardTypesInGraveyardHint copy() {
        return new CardTypesInGraveyardHint(this);
    }
}

