/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.dynamicvalue.common;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.filter.FilterPermanent;
import mage.game.Game;

public class PermanentsOnBattlefieldCount
implements DynamicValue {
    private final FilterPermanent filter;
    private final Integer multiplier;

    public PermanentsOnBattlefieldCount() {
        this(new FilterPermanent(), 1);
    }

    public PermanentsOnBattlefieldCount(FilterPermanent filter) {
        this(filter, 1);
    }

    public PermanentsOnBattlefieldCount(FilterPermanent filter, Integer multiplier) {
        this.filter = filter;
        this.multiplier = multiplier;
    }

    protected PermanentsOnBattlefieldCount(PermanentsOnBattlefieldCount dynamicValue) {
        this.filter = dynamicValue.filter;
        this.multiplier = dynamicValue.multiplier;
    }

    @Override
    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        int value = game.getBattlefield().count(this.filter, sourceAbility.getControllerId(), sourceAbility, game);
        if (this.multiplier != null) {
            value *= this.multiplier.intValue();
        }
        return value;
    }

    @Override
    public PermanentsOnBattlefieldCount copy() {
        return new PermanentsOnBattlefieldCount(this);
    }

    public String toString() {
        return this.multiplier == null ? "X" : this.multiplier.toString();
    }

    @Override
    public String getMessage() {
        return this.multiplier == null ? "the number of " + this.filter.getMessage() : this.filter.getMessage();
    }

    @Override
    public int getSign() {
        return this.multiplier == null ? 1 : this.multiplier;
    }
}

