/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.dynamicvalue.common;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.cards.Card;
import mage.game.Game;

public enum TotalCardsExiledOwnedManaValue implements DynamicValue
{
    instance;

    private static final Hint hint;

    @Override
    public TotalCardsExiledOwnedManaValue copy() {
        return this;
    }

    @Override
    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        int totalCMC = 0;
        List<Card> cards = game.getExile().getCardsOwned(game, sourceAbility.getControllerId());
        for (Card card : cards) {
            totalCMC += card.getManaValue();
        }
        return totalCMC;
    }

    @Override
    public String getMessage() {
        return "the total mana value of cards you own in exile";
    }

    public String toString() {
        return "X";
    }

    public static Hint getHint() {
        return hint;
    }

    static {
        hint = new ValueHint("Total mana value of cards you own in exile", instance);
    }
}

