/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.Effects;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

public class AsTurnedFaceUpEffect
extends ReplacementEffectImpl {
    protected Effects baseEffects = new Effects(new Effect[0]);
    protected boolean optional;

    public AsTurnedFaceUpEffect(Effect baseEffect, boolean optional) {
        super(Duration.WhileOnBattlefield, baseEffect.getOutcome(), true);
        this.baseEffects.add(baseEffect);
        this.optional = optional;
    }

    protected AsTurnedFaceUpEffect(AsTurnedFaceUpEffect effect) {
        super(effect);
        this.baseEffects = effect.baseEffects.copy();
        this.optional = effect.optional;
    }

    public void addEffect(Effect effect) {
        this.baseEffects.add(effect);
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TURN_FACE_UP;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId().equals(source.getSourceId());
    }

    @Override
    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        if (this.optional) {
            Player controller = game.getPlayer(source.getControllerId());
            MageObject object = game.getObject(source);
            if (controller == null || object == null) {
                return false;
            }
            if (!controller.chooseUse(this.outcome, "Use effect of " + object.getIdName() + "?", source, game)) {
                return false;
            }
        }
        for (Effect effect : this.baseEffects) {
            if (!source.activate(game, false)) continue;
            if (effect instanceof ContinuousEffect) {
                game.addEffect((ContinuousEffect)effect, source);
                continue;
            }
            effect.apply(game, source);
        }
        return false;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "As {this} is turned face up, " + this.baseEffects.getText(mode);
    }

    @Override
    public AsTurnedFaceUpEffect copy() {
        return new AsTurnedFaceUpEffect(this);
    }
}

