/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.CompoundAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.EffectImpl;
import mage.abilities.keyword.ChangelingAbility;
import mage.constants.AbilityType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.EffectType;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.constants.TurnPhase;
import mage.constants.Zone;
import mage.filter.Filter;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.target.targetpointer.TargetPointer;
import mage.watchers.common.EndStepCountWatcher;

public abstract class ContinuousEffectImpl
extends EffectImpl
implements ContinuousEffect {
    protected Duration duration;
    protected Layer layer;
    protected SubLayer sublayer;
    protected long order;
    protected boolean used = false;
    protected boolean discarded = false;
    private Boolean affectedObjectsSet = null;
    protected List<MageObjectReference> affectedObjectList = new ArrayList<MageObjectReference>();
    protected boolean temporary = false;
    protected EnumSet<DependencyType> dependencyTypes;
    protected EnumSet<DependencyType> dependendToTypes;
    protected boolean characterDefining = false;
    private UUID startingControllerId;
    private boolean startingTurnWasActive;
    private int effectStartingOnTurn = 0;
    private int effectStartingEndStep = 0;
    private int nextTurnNumber = Integer.MAX_VALUE;
    private int effectStartingStepNum = 0;

    protected ContinuousEffectImpl(Duration duration, Outcome outcome) {
        super(outcome);
        this.duration = duration;
        this.order = 0L;
        this.effectType = EffectType.CONTINUOUS;
        this.dependencyTypes = EnumSet.noneOf(DependencyType.class);
        this.dependendToTypes = EnumSet.noneOf(DependencyType.class);
    }

    protected ContinuousEffectImpl(Duration duration, Layer layer, SubLayer sublayer, Outcome outcome) {
        this(duration, outcome);
        this.layer = layer;
        this.sublayer = sublayer;
    }

    protected ContinuousEffectImpl(ContinuousEffectImpl effect) {
        super(effect);
        this.duration = effect.duration;
        this.layer = effect.layer;
        this.sublayer = effect.sublayer;
        this.order = effect.order;
        this.used = effect.used;
        this.discarded = effect.discarded;
        this.affectedObjectsSet = effect.affectedObjectsSet;
        this.affectedObjectList.addAll(effect.affectedObjectList);
        this.temporary = effect.temporary;
        this.startingControllerId = effect.startingControllerId;
        this.startingTurnWasActive = effect.startingTurnWasActive;
        this.effectStartingOnTurn = effect.effectStartingOnTurn;
        this.effectStartingEndStep = effect.effectStartingEndStep;
        this.dependencyTypes = effect.dependencyTypes;
        this.dependendToTypes = effect.dependendToTypes;
        this.characterDefining = effect.characterDefining;
        this.nextTurnNumber = effect.nextTurnNumber;
        this.effectStartingStepNum = effect.effectStartingStepNum;
    }

    @Override
    public ContinuousEffectImpl setDuration(Duration duration) {
        this.duration = duration;
        return this;
    }

    @Override
    public Duration getDuration() {
        return this.duration;
    }

    @Override
    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        if (this.layer == layer && this.sublayer == sublayer) {
            return this.apply(game, source);
        }
        return false;
    }

    @Override
    public long getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(long order) {
        this.order = order;
    }

    @Override
    public boolean hasLayer(Layer layer) {
        return this.layer == layer;
    }

    @Override
    public boolean isUsed() {
        return this.used;
    }

    @Override
    public boolean isDiscarded() {
        return this.discarded;
    }

    @Override
    public void discard() {
        this.used = true;
        this.discarded = true;
    }

    @Override
    public final void initNewTargetPointer() {
    }

    @Override
    public void init(Ability source, Game game) {
        this.init(source, game, game.getActivePlayerId());
    }

    @Override
    public void init(Ability source, Game game, UUID activePlayerId) {
        this.getTargetPointer().init(game, source);
        if (this.affectedObjectsSet == null) {
            this.initAffectedObjectsSet(source);
        }
        this.setStartingControllerAndTurnNum(game, source.getControllerId(), activePlayerId);
    }

    private void initAffectedObjectsSet(Ability source) {
        this.affectedObjectsSet = false;
        if (AbilityType.STATIC != source.getAbilityType()) {
            if (this.layer != null) {
                switch (this.layer) {
                    case CopyEffects_1: 
                    case ControlChangingEffects_2: 
                    case TextChangingEffects_3: 
                    case TypeChangingEffects_4: 
                    case ColorChangingEffects_5: 
                    case AbilityAddingRemovingEffects_6: 
                    case PTChangingEffects_7: {
                        this.affectedObjectsSet = true;
                    }
                }
            } else if (this.hasLayer(Layer.CopyEffects_1) || this.hasLayer(Layer.ControlChangingEffects_2) || this.hasLayer(Layer.TextChangingEffects_3) || this.hasLayer(Layer.TypeChangingEffects_4) || this.hasLayer(Layer.ColorChangingEffects_5) || this.hasLayer(Layer.AbilityAddingRemovingEffects_6) || this.hasLayer(Layer.PTChangingEffects_7)) {
                this.affectedObjectsSet = true;
            }
        }
    }

    protected boolean getAffectedObjectsSetAtInit(Ability source) {
        if (this.affectedObjectsSet == null) {
            this.initAffectedObjectsSet(source);
        }
        return this.affectedObjectsSet;
    }

    protected boolean getAffectedObjectsSet() {
        if (this.affectedObjectsSet == null) {
            return false;
        }
        return this.affectedObjectsSet;
    }

    protected void setAffectedObjectsSet(boolean affectedObjectsSet) {
        this.affectedObjectsSet = affectedObjectsSet;
    }

    @Override
    public UUID getStartingController() {
        return this.startingControllerId;
    }

    @Override
    public void setStartingControllerAndTurnNum(Game game, UUID startingController, UUID activePlayerId) {
        this.startingControllerId = startingController;
        this.startingTurnWasActive = activePlayerId != null && activePlayerId.equals(startingController);
        this.effectStartingOnTurn = game.getTurnNum();
        this.effectStartingEndStep = EndStepCountWatcher.getCount(startingController, game);
        this.effectStartingStepNum = game.getState().getStepNum();
    }

    @Override
    public boolean isYourNextTurn(Game game) {
        return this.effectStartingOnTurn < game.getTurnNum() && game.isActivePlayer(this.startingControllerId);
    }

    @Override
    public boolean isYourNextEndStep(Game game) {
        return EndStepCountWatcher.getCount(this.startingControllerId, game) > this.effectStartingEndStep;
    }

    public boolean isEndCombatOfYourNextTurn(Game game) {
        int currentTurn = game.getTurnNum();
        if (this.nextTurnNumber != Integer.MAX_VALUE && this.nextTurnNumber < currentTurn) {
            return false;
        }
        if (this.nextTurnNumber == Integer.MAX_VALUE && this.isYourNextTurn(game)) {
            this.nextTurnNumber = currentTurn;
        }
        return this.isYourNextTurn(game) && game.getPhase().getType() == TurnPhase.POSTCOMBAT_MAIN;
    }

    @Override
    public boolean isYourNextUpkeepStep(Game game) {
        return (this.effectStartingOnTurn < game.getTurnNum() || this.effectStartingStepNum < game.getState().getStepNum()) && game.isActivePlayer(this.startingControllerId) && game.getStep().getType() == PhaseStep.UPKEEP;
    }

    @Override
    public boolean isInactive(Ability source, Game game) {
        boolean canDelete;
        switch (this.duration) {
            case UntilYourNextTurn: 
            case UntilEndOfYourNextTurn: 
            case UntilYourNextEndStep: 
            case UntilEndCombatOfYourNextTurn: 
            case UntilYourNextUpkeepStep: {
                break;
            }
            default: {
                return false;
            }
        }
        if (game.getActivePlayerId() == null) {
            return false;
        }
        Player player = game.getPlayer(this.startingControllerId);
        switch (this.duration) {
            case UntilYourNextTurn: 
            case UntilEndOfYourNextTurn: {
                canDelete = player == null || !player.isInGame() && player.hasReachedNextTurnAfterLeaving();
                break;
            }
            default: {
                canDelete = false;
            }
        }
        if (canDelete) {
            return true;
        }
        switch (this.duration) {
            case UntilYourNextTurn: {
                if (player == null || !player.isInGame()) break;
                return this.isYourNextTurn(game);
            }
            case UntilYourNextEndStep: {
                if (player == null || !player.isInGame()) break;
                return this.isYourNextEndStep(game);
            }
            case UntilEndCombatOfYourNextTurn: {
                if (player == null || !player.isInGame()) break;
                return this.isEndCombatOfYourNextTurn(game);
            }
            case UntilYourNextUpkeepStep: {
                if (player == null || !player.isInGame()) break;
                return this.isYourNextUpkeepStep(game);
            }
        }
        return canDelete;
    }

    @Override
    public Layer getLayer() {
        return this.layer;
    }

    @Override
    public SubLayer getSublayer() {
        return this.sublayer;
    }

    @Override
    public List<MageObjectReference> getAffectedObjects() {
        return this.affectedObjectList;
    }

    @Override
    public boolean isTemporary() {
        return this.temporary;
    }

    @Override
    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    public boolean isCharacterDefining() {
        return this.characterDefining;
    }

    public void setCharacterDefining(boolean characterDefining) {
        this.characterDefining = characterDefining;
    }

    @Override
    public Set<UUID> isDependentTo(List<ContinuousEffect> allEffectsInLayer) {
        HashSet<UUID> dependentToEffects = new HashSet<UUID>();
        if (this.dependendToTypes != null) {
            block0: for (ContinuousEffect effect : allEffectsInLayer) {
                if (effect.getId().equals(this.getId())) continue;
                for (DependencyType dependencyType : effect.getDependencyTypes()) {
                    if (!this.dependendToTypes.contains((Object)dependencyType)) continue;
                    dependentToEffects.add(effect.getId());
                    continue block0;
                }
            }
        }
        return dependentToEffects;
    }

    @Override
    public EnumSet<DependencyType> getDependencyTypes() {
        return this.dependencyTypes;
    }

    @Override
    public EnumSet<DependencyType> getDependedToTypes() {
        return this.dependendToTypes;
    }

    @Override
    public void addDependencyType(DependencyType dependencyType) {
        if (dependencyType != null) {
            this.dependencyTypes.add(dependencyType);
        }
    }

    @Override
    public void setDependedToType(DependencyType dependencyType) {
        this.dependendToTypes.clear();
        this.dependendToTypes.add(dependencyType);
    }

    @Override
    public void addDependedToType(DependencyType dependencyType) {
        this.dependendToTypes.add(dependencyType);
    }

    @Override
    public ContinuousEffect setTargetPointer(TargetPointer targetPointer) {
        super.setTargetPointer(targetPointer);
        return this;
    }

    @Override
    public ContinuousEffect withTargetDescription(String target) {
        super.withTargetDescription(target);
        return this;
    }

    public void generateGainAbilityDependencies(Ability abilityToGain, Filter filterToSearch) {
        this.addDependencyType(DependencyType.AddingAbility);
        this.generateGainAbilityDependenciesFromAbility(abilityToGain);
        this.generateGainAbilityDependenciesFromFilter(filterToSearch);
    }

    public void generateGainAbilityDependencies(CompoundAbility abilityToGain, Filter filterToSearch) {
        this.addDependencyType(DependencyType.AddingAbility);
        this.generateGainAbilityDependenciesFromAbility(abilityToGain);
        this.generateGainAbilityDependenciesFromFilter(filterToSearch);
    }

    private void generateGainAbilityDependenciesFromAbility(CompoundAbility compoundAbility) {
        if (compoundAbility == null) {
            return;
        }
        for (Ability ability : compoundAbility) {
            this.generateGainAbilityDependenciesFromAbility(ability);
        }
    }

    private void generateGainAbilityDependenciesFromAbility(Ability ability) {
        if (ability == null) {
            return;
        }
        if (ability instanceof ChangelingAbility) {
            this.addDependencyType(DependencyType.AddingCreatureType);
        }
    }

    private void generateGainAbilityDependenciesFromFilter(Filter filter) {
        if (filter == null) {
            return;
        }
        ArrayList<Predicate> list = new ArrayList<Predicate>();
        Predicates.collectAllComponents(filter.getPredicates(), filter.getExtraPredicates(), list);
        if (list.stream().anyMatch(SubType.SubTypePredicate.class::isInstance)) {
            this.addDependedToType(DependencyType.AddingCreatureType);
        }
    }

    public boolean canLookAtNextTopLibraryCard(Game game) {
        StackObject stackObject = game.getStack().getFirstOrNull();
        return !(stackObject instanceof Spell) || !Zone.LIBRARY.equals((Object)((Spell)stackObject).getFromZone()) || stackObject.getStackAbility().getManaCostsToPay().isPaid();
    }

    @Override
    public ContinuousEffect setText(String staticText) {
        super.setText(staticText);
        return this;
    }
}

