/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.ApprovingObject;
import mage.MageItem;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.MageSingleton;
import mage.abilities.StaticAbility;
import mage.abilities.effects.ApplyStatusEffect;
import mage.abilities.effects.AsThoughEffect;
import mage.abilities.effects.AsThoughManaEffect;
import mage.abilities.effects.AuraReplacementEffect;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.ContinuousEffectsList;
import mage.abilities.effects.ContinuousRuleModifyingEffect;
import mage.abilities.effects.CostModificationEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.PayCostToAttackBlockEffect;
import mage.abilities.effects.PreventionEffect;
import mage.abilities.effects.ReplacementEffect;
import mage.abilities.effects.RequirementEffect;
import mage.abilities.effects.RestrictionEffect;
import mage.abilities.effects.RestrictionUntapNotMoreThanEffect;
import mage.abilities.effects.SpliceCardEffect;
import mage.abilities.effects.common.continuous.BecomesFaceDownCreatureEffect;
import mage.abilities.effects.common.continuous.CommanderReplacementEffect;
import mage.cards.CardWithSpellOption;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.ModalDoubleFacedCardHalf;
import mage.cards.SplitCardHalf;
import mage.constants.AbilityType;
import mage.constants.AsThoughEffectType;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.EffectType;
import mage.constants.Layer;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.CardIdPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.game.stack.Spell;
import mage.players.ManaPoolItem;
import mage.players.Player;
import mage.target.common.TargetCardInHand;
import org.apache.log4j.Logger;

public class ContinuousEffects
implements Serializable {
    private static final Logger logger = Logger.getLogger(ContinuousEffects.class);
    private long order = 0L;
    private ContinuousEffectsList<ContinuousEffect> layeredEffects = new ContinuousEffectsList();
    private ContinuousEffectsList<ContinuousRuleModifyingEffect> continuousRuleModifyingEffects = new ContinuousEffectsList();
    private ContinuousEffectsList<ReplacementEffect> replacementEffects = new ContinuousEffectsList();
    private ContinuousEffectsList<PreventionEffect> preventionEffects = new ContinuousEffectsList();
    private ContinuousEffectsList<RequirementEffect> requirementEffects = new ContinuousEffectsList();
    private ContinuousEffectsList<RestrictionEffect> restrictionEffects = new ContinuousEffectsList();
    private ContinuousEffectsList<RestrictionUntapNotMoreThanEffect> restrictionUntapNotMoreThanEffects = new ContinuousEffectsList();
    private ContinuousEffectsList<CostModificationEffect> costModificationEffects = new ContinuousEffectsList();
    private ContinuousEffectsList<SpliceCardEffect> spliceCardEffects = new ContinuousEffectsList();
    private final Map<AsThoughEffectType, ContinuousEffectsList<AsThoughEffect>> asThoughEffectsMap = new EnumMap<AsThoughEffectType, ContinuousEffectsList<AsThoughEffect>>(AsThoughEffectType.class);
    public final List<ContinuousEffectsList<?>> allEffectsLists = new ArrayList();
    private final ApplyStatusEffect applyStatus;
    private final AuraReplacementEffect auraReplacementEffect;
    private final Map<String, ContinuousEffectsList<ContinuousEffect>> lastEffectsListOnLayer = new HashMap<String, ContinuousEffectsList<ContinuousEffect>>();

    public ContinuousEffects() {
        this.applyStatus = new ApplyStatusEffect();
        this.auraReplacementEffect = new AuraReplacementEffect();
        this.collectAllEffects();
    }

    protected ContinuousEffects(ContinuousEffects effect) {
        this.applyStatus = effect.applyStatus.copy();
        this.auraReplacementEffect = effect.auraReplacementEffect.copy();
        this.layeredEffects = effect.layeredEffects.copy();
        this.continuousRuleModifyingEffects = effect.continuousRuleModifyingEffects.copy();
        this.replacementEffects = effect.replacementEffects.copy();
        this.preventionEffects = effect.preventionEffects.copy();
        this.requirementEffects = effect.requirementEffects.copy();
        this.restrictionEffects = effect.restrictionEffects.copy();
        this.restrictionUntapNotMoreThanEffects = effect.restrictionUntapNotMoreThanEffects.copy();
        for (Map.Entry<AsThoughEffectType, ContinuousEffectsList<AsThoughEffect>> entry : effect.asThoughEffectsMap.entrySet()) {
            this.asThoughEffectsMap.put(entry.getKey(), entry.getValue().copy());
        }
        this.costModificationEffects = effect.costModificationEffects.copy();
        this.spliceCardEffects = effect.spliceCardEffects.copy();
        for (Map.Entry<Object, ContinuousEffectsList<ContinuousEffect>> entry : effect.lastEffectsListOnLayer.entrySet()) {
            this.lastEffectsListOnLayer.put((String)entry.getKey(), entry.getValue().copy());
        }
        this.collectAllEffects();
        this.order = effect.order;
    }

    private synchronized void collectAllEffects() {
        this.allEffectsLists.add(this.layeredEffects);
        this.allEffectsLists.add(this.continuousRuleModifyingEffects);
        this.allEffectsLists.add(this.replacementEffects);
        this.allEffectsLists.add(this.preventionEffects);
        this.allEffectsLists.add(this.requirementEffects);
        this.allEffectsLists.add(this.restrictionEffects);
        this.allEffectsLists.add(this.restrictionUntapNotMoreThanEffects);
        this.allEffectsLists.add(this.costModificationEffects);
        this.allEffectsLists.add(this.spliceCardEffects);
        for (ContinuousEffectsList<AsThoughEffect> continuousEffectsList : this.asThoughEffectsMap.values()) {
            this.allEffectsLists.add(continuousEffectsList);
        }
    }

    public ContinuousEffects copy() {
        return new ContinuousEffects(this);
    }

    public List<RequirementEffect> getRequirementEffects() {
        return this.requirementEffects;
    }

    public List<RestrictionEffect> getRestrictionEffects() {
        return this.restrictionEffects;
    }

    public synchronized void removeEndOfCombatEffects() {
        this.layeredEffects.removeEndOfCombatEffects();
        this.continuousRuleModifyingEffects.removeEndOfCombatEffects();
        this.replacementEffects.removeEndOfCombatEffects();
        this.preventionEffects.removeEndOfCombatEffects();
        this.requirementEffects.removeEndOfCombatEffects();
        this.restrictionEffects.removeEndOfCombatEffects();
        for (ContinuousEffectsList<AsThoughEffect> asThoughlist : this.asThoughEffectsMap.values()) {
            asThoughlist.removeEndOfCombatEffects();
        }
        this.costModificationEffects.removeEndOfCombatEffects();
        this.spliceCardEffects.removeEndOfCombatEffects();
    }

    public synchronized void removeEndOfTurnEffects(Game game) {
        this.layeredEffects.removeEndOfTurnEffects(game);
        this.continuousRuleModifyingEffects.removeEndOfTurnEffects(game);
        this.replacementEffects.removeEndOfTurnEffects(game);
        this.preventionEffects.removeEndOfTurnEffects(game);
        this.requirementEffects.removeEndOfTurnEffects(game);
        this.restrictionEffects.removeEndOfTurnEffects(game);
        for (ContinuousEffectsList<AsThoughEffect> asThoughlist : this.asThoughEffectsMap.values()) {
            asThoughlist.removeEndOfTurnEffects(game);
        }
        this.costModificationEffects.removeEndOfTurnEffects(game);
        this.spliceCardEffects.removeEndOfTurnEffects(game);
    }

    public synchronized void removeBeginningOfEndStepEffects(Game game) {
        this.layeredEffects.removeBeginningOfEndStepEffects(game);
        this.continuousRuleModifyingEffects.removeBeginningOfEndStepEffects(game);
        this.replacementEffects.removeBeginningOfEndStepEffects(game);
        this.preventionEffects.removeBeginningOfEndStepEffects(game);
        this.requirementEffects.removeBeginningOfEndStepEffects(game);
        this.restrictionEffects.removeBeginningOfEndStepEffects(game);
        for (ContinuousEffectsList<AsThoughEffect> asThoughlist : this.asThoughEffectsMap.values()) {
            asThoughlist.removeBeginningOfEndStepEffects(game);
        }
        this.costModificationEffects.removeBeginningOfEndStepEffects(game);
        this.spliceCardEffects.removeBeginningOfEndStepEffects(game);
    }

    public synchronized void removeInactiveEffects(Game game) {
        this.layeredEffects.removeInactiveEffects(game);
        this.continuousRuleModifyingEffects.removeInactiveEffects(game);
        this.replacementEffects.removeInactiveEffects(game);
        this.preventionEffects.removeInactiveEffects(game);
        this.requirementEffects.removeInactiveEffects(game);
        this.restrictionEffects.removeInactiveEffects(game);
        this.restrictionUntapNotMoreThanEffects.removeInactiveEffects(game);
        for (ContinuousEffectsList<AsThoughEffect> asThoughtlist : this.asThoughEffectsMap.values()) {
            asThoughtlist.removeInactiveEffects(game);
        }
        this.costModificationEffects.removeInactiveEffects(game);
        this.spliceCardEffects.removeInactiveEffects(game);
    }

    public synchronized List<ContinuousEffect> getLayeredEffects(Game game) {
        return this.getLayeredEffects(game, "main");
    }

    public synchronized List<ContinuousEffect> getLayeredEffects(Game game, String timestampGroupName) {
        ArrayList<ContinuousEffect> layerEffects = new ArrayList<ContinuousEffect>();
        block3: for (ContinuousEffect effect : this.layeredEffects) {
            block0 : switch (effect.getDuration()) {
                case WhileOnBattlefield: 
                case WhileControlled: 
                case WhileOnStack: 
                case WhileInGraveyard: {
                    Set<Ability> abilities = this.layeredEffects.getAbility(effect.getId());
                    if (!abilities.isEmpty()) {
                        for (Ability ability : abilities) {
                            if (ability instanceof StaticAbility && !ability.isInUseableZone(game, null, null)) continue;
                            layerEffects.add(effect);
                            break block0;
                        }
                        continue block3;
                    }
                    logger.error((Object)("No abilities for continuous effect: " + effect));
                    break;
                }
                default: {
                    layerEffects.add(effect);
                }
            }
        }
        this.updateTimestamps(timestampGroupName, layerEffects);
        layerEffects.sort(Comparator.comparingLong(ContinuousEffect::getOrder));
        return layerEffects;
    }

    private synchronized void updateTimestamps(String timestampGroupName, List<ContinuousEffect> layerEffects) {
        if (!this.lastEffectsListOnLayer.containsKey(timestampGroupName)) {
            this.lastEffectsListOnLayer.put(timestampGroupName, new ContinuousEffectsList());
        }
        ContinuousEffectsList<ContinuousEffect> prevs = this.lastEffectsListOnLayer.get(timestampGroupName);
        for (ContinuousEffect continuousEffect : layerEffects) {
            if (prevs.contains(continuousEffect)) continue;
            this.setOrder(continuousEffect);
        }
        prevs.clear();
        prevs.addAll(layerEffects);
    }

    public void setOrder(ContinuousEffect effect) {
        effect.setOrder(this.order++);
    }

    private List<ContinuousEffect> filterLayeredEffects(List<ContinuousEffect> effects, Layer layer) {
        return effects.stream().filter(effect -> effect.hasLayer(layer)).collect(Collectors.toList());
    }

    public Map<RequirementEffect, Set<Ability>> getApplicableRequirementEffects(Permanent permanent, boolean playerRelated, Game game) {
        HashMap<RequirementEffect, Set<Ability>> effects = new HashMap<RequirementEffect, Set<Ability>>();
        for (RequirementEffect effect : this.requirementEffects) {
            if (playerRelated != effect.isPlayerRelated()) continue;
            Set<Ability> abilities = this.requirementEffects.getAbility(effect.getId());
            HashSet<Ability> applicableAbilities = new HashSet<Ability>();
            for (Ability ability : abilities) {
                if (ability instanceof StaticAbility && !ability.isInUseableZone(game, ability instanceof MageSingleton ? permanent : null, null) || !effect.applies(permanent, ability, game)) continue;
                applicableAbilities.add(ability);
            }
            if (applicableAbilities.isEmpty()) continue;
            effects.put(effect, abilities);
        }
        return effects;
    }

    public Map<RestrictionEffect, Set<Ability>> getApplicableRestrictionEffects(Permanent permanent, Game game) {
        HashMap<RestrictionEffect, Set<Ability>> effects = new HashMap<RestrictionEffect, Set<Ability>>();
        for (RestrictionEffect effect : this.restrictionEffects) {
            Set<Ability> abilities = this.restrictionEffects.getAbility(effect.getId());
            HashSet<Ability> applicableAbilities = new HashSet<Ability>();
            for (Ability ability : abilities) {
                if (ability instanceof StaticAbility && !ability.isInUseableZone(game, ability instanceof MageSingleton ? permanent : null, null) || !effect.applies(permanent, ability, game)) continue;
                applicableAbilities.add(ability);
            }
            if (applicableAbilities.isEmpty()) continue;
            effects.put(effect, abilities);
        }
        return effects;
    }

    public Map<RestrictionUntapNotMoreThanEffect, Set<Ability>> getApplicableRestrictionUntapNotMoreThanEffects(Player player, Game game) {
        HashMap<RestrictionUntapNotMoreThanEffect, Set<Ability>> effects = new HashMap<RestrictionUntapNotMoreThanEffect, Set<Ability>>();
        for (RestrictionUntapNotMoreThanEffect effect : this.restrictionUntapNotMoreThanEffects) {
            Set<Ability> abilities = this.restrictionUntapNotMoreThanEffects.getAbility(effect.getId());
            HashSet<Ability> applicableAbilities = new HashSet<Ability>();
            for (Ability ability : abilities) {
                if (ability instanceof StaticAbility && !ability.isInUseableZone(game, null, null) || !effect.applies(player, ability, game)) continue;
                applicableAbilities.add(ability);
            }
            if (applicableAbilities.isEmpty()) continue;
            effects.put(effect, abilities);
        }
        return effects;
    }

    public boolean checkIfThereArePayCostToAttackBlockEffects(GameEvent event, Game game) {
        for (ReplacementEffect effect : this.replacementEffects) {
            if (!effect.checksEventType(event, game) || !(effect instanceof PayCostToAttackBlockEffect)) continue;
            Set<Ability> abilities = this.replacementEffects.getAbility(effect.getId());
            for (Ability ability : abilities) {
                if (ability.getAbilityType() == AbilityType.STATIC && !ability.isInUseableZone(game, null, event) || effect.getDuration() == Duration.OneUse && effect.isUsed() || game.getScopeRelevant() && !effect.hasSelfScope() && event.getTargetId().equals(ability.getSourceId()) || !effect.applies(event, ability, game) || ((PayCostToAttackBlockEffect)effect).isCostless(event, ability, game)) continue;
                return true;
            }
        }
        return false;
    }

    private Map<ReplacementEffect, Set<Ability>> getApplicableReplacementEffects(GameEvent event, Game game) {
        HashSet<Ability> applicableAbilities;
        Set<Ability> abilities;
        LinkedHashMap<ReplacementEffect, Set<Ability>> replaceEffects = new LinkedHashMap<ReplacementEffect, Set<Ability>>();
        if (this.auraReplacementEffect.checksEventType(event, game) && this.auraReplacementEffect.applies(event, null, game)) {
            replaceEffects.put(this.auraReplacementEffect, null);
        }
        for (ReplacementEffect replacementEffect : this.replacementEffects) {
            if (!replacementEffect.checksEventType(event, game) || event.getAppliedEffects() != null && event.getAppliedEffects().contains(replacementEffect.getId()) && !(replacementEffect instanceof CommanderReplacementEffect)) continue;
            abilities = this.replacementEffects.getAbility(replacementEffect.getId());
            applicableAbilities = new HashSet<Ability>();
            for (Ability ability : abilities) {
                if (ability.getAbilityType() == AbilityType.STATIC && !ability.isInUseableZone(game, null, event) || replacementEffect.isUsed() || game.getScopeRelevant() && !replacementEffect.hasSelfScope() && event.getTargetId().equals(ability.getSourceId()) || !replacementEffect.applies(event, ability, game)) continue;
                applicableAbilities.add(ability);
            }
            if (applicableAbilities.isEmpty()) continue;
            replaceEffects.put(replacementEffect, applicableAbilities);
        }
        for (PreventionEffect preventionEffect : this.preventionEffects) {
            if (!preventionEffect.checksEventType(event, game) || event.getAppliedEffects() != null && event.getAppliedEffects().contains(preventionEffect.getId())) continue;
            abilities = this.preventionEffects.getAbility(preventionEffect.getId());
            applicableAbilities = new HashSet();
            for (Ability ability : abilities) {
                if (ability.getAbilityType() == AbilityType.STATIC && !ability.isInUseableZone(game, null, event) || preventionEffect.getDuration() == Duration.OneUse && preventionEffect.isUsed() || !preventionEffect.applies(event, ability, game)) continue;
                applicableAbilities.add(ability);
            }
            if (applicableAbilities.isEmpty()) continue;
            replaceEffects.put(preventionEffect, applicableAbilities);
        }
        return replaceEffects;
    }

    private boolean checkAbilityStillExists(Ability ability, ContinuousEffect effect, GameEvent event, Game game) {
        Spell spell;
        PermanentCard permanent;
        switch (effect.getDuration()) {
            case EndOfCombat: 
            case EndOfGame: 
            case EndOfStep: 
            case EndOfTurn: 
            case OneUse: 
            case Custom: {
                return true;
            }
        }
        if (ability.getSourceId() == null) {
            return true;
        }
        MageObject object = event.getType() == GameEvent.EventType.ZONE_CHANGE && ((ZoneChangeEvent)event).getFromZone() == Zone.BATTLEFIELD && event.getTargetId().equals(ability.getSourceId()) ? ((ZoneChangeEvent)event).getTarget() : game.getObject(ability.getSourceId());
        if (object == null) {
            return false;
        }
        boolean exists = true;
        if (!object.hasAbility(ability, game)) {
            PermanentCard permanent2;
            exists = false;
            if (object instanceof PermanentCard && (permanent2 = (PermanentCard)object).isTransformable() && event.getType() == GameEvent.EventType.TRANSFORMED) {
                exists = permanent2.getCard().hasAbility(ability, game);
            }
        } else if (object instanceof PermanentCard ? (permanent = (PermanentCard)object).isFaceDown(game) && !ability.getWorksFaceDown() : object instanceof Spell && (spell = (Spell)object).isFaceDown(game) && !ability.getWorksFaceDown()) {
            return false;
        }
        return exists;
    }

    private List<CostModificationEffect> getApplicableCostModificationEffects(Game game) {
        ArrayList<CostModificationEffect> costEffects = new ArrayList<CostModificationEffect>();
        block0: for (CostModificationEffect effect : this.costModificationEffects) {
            Set<Ability> abilities = this.costModificationEffects.getAbility(effect.getId());
            for (Ability ability : abilities) {
                if (ability instanceof StaticAbility && !ability.isInUseableZone(game, null, null) || effect.getDuration() == Duration.OneUse && effect.isUsed()) continue;
                costEffects.add(effect);
                continue block0;
            }
        }
        return costEffects;
    }

    private List<SpliceCardEffect> getApplicableSpliceCardEffects(Game game, UUID playerId) {
        ArrayList<SpliceCardEffect> spliceEffects = new ArrayList<SpliceCardEffect>();
        block0: for (SpliceCardEffect effect : this.spliceCardEffects) {
            Set<Ability> abilities = this.spliceCardEffects.getAbility(effect.getId());
            for (Ability ability : abilities) {
                if (!ability.isControlledBy(playerId) || ability instanceof StaticAbility && !ability.isInUseableZone(game, null, null) || effect.getDuration() == Duration.OneUse && effect.isUsed()) continue;
                spliceEffects.add(effect);
                continue block0;
            }
        }
        return spliceEffects;
    }

    public Set<ApprovingObject> asThough(UUID objectId, AsThoughEffectType type, Ability affectedAbility, UUID controllerId, Game game) {
        HashSet<ApprovingObject> possibleApprovingObjects = new HashSet<ApprovingObject>();
        if (type.needAffectedAbility() && affectedAbility == null) {
            throw new IllegalArgumentException("Wrong code usage: you can't call asThough check to whole object, call it with affected ability instead: " + (Object)((Object)type));
        }
        if (!type.needAffectedAbility() && affectedAbility != null) {
            throw new IllegalArgumentException("Wrong code usage: you can't call AsThough check to affected ability, call it with empty affected ability instead: " + (Object)((Object)type));
        }
        List<AsThoughEffect> asThoughEffectsList = this.getApplicableAsThoughEffects(type, game);
        if (!asThoughEffectsList.isEmpty()) {
            MageObject objectToCheck = affectedAbility != null ? affectedAbility.getSourceObject(game) : game.getCard(objectId);
            UUID idToCheck = !type.needPlayCardAbility() && objectToCheck instanceof SplitCardHalf ? ((SplitCardHalf)objectToCheck).getMainCard().getId() : (!type.needPlayCardAbility() && objectToCheck instanceof CardWithSpellOption ? ((CardWithSpellOption)objectToCheck).getMainCard().getId() : (!type.needPlayCardAbility() && objectToCheck instanceof ModalDoubleFacedCardHalf ? ((ModalDoubleFacedCardHalf)objectToCheck).getMainCard().getId() : objectId));
            for (AsThoughEffect effect : asThoughEffectsList) {
                Set<Ability> abilities = this.asThoughEffectsMap.get((Object)type).getAbility(effect.getId());
                for (Ability ability : abilities) {
                    if (affectedAbility == null) {
                        if (!effect.applies(idToCheck, ability, controllerId, game)) continue;
                        possibleApprovingObjects.add(new ApprovingObject(ability, game));
                        continue;
                    }
                    if (type.needPlayCardAbility() && !affectedAbility.getAbilityType().isPlayCardAbility() || !effect.applies(idToCheck, affectedAbility, ability, game, controllerId)) continue;
                    possibleApprovingObjects.add(new ApprovingObject(ability, game));
                }
            }
        }
        return possibleApprovingObjects;
    }

    public ManaType asThoughMana(ManaType manaType, ManaPoolItem mana, UUID objectId, Ability affectedAbility, UUID controllerId, Game game) {
        Set<Ability> abilities;
        List<AsThoughEffect> asThoughEffectsList = this.getApplicableAsThoughEffects(AsThoughEffectType.SPEND_ONLY_MANA, game);
        for (AsThoughEffect effect : asThoughEffectsList) {
            abilities = this.asThoughEffectsMap.get((Object)AsThoughEffectType.SPEND_ONLY_MANA).getAbility(effect.getId());
            for (Ability ability : abilities) {
                if ((affectedAbility != null || !effect.applies(objectId, ability, controllerId, game)) && !effect.applies(objectId, affectedAbility, ability, game, controllerId) || ((AsThoughManaEffect)effect).getAsThoughManaType(manaType, mana, controllerId, ability, game) != null) continue;
                return null;
            }
        }
        asThoughEffectsList = this.getApplicableAsThoughEffects(AsThoughEffectType.SPEND_OTHER_MANA, game);
        for (AsThoughEffect effect : asThoughEffectsList) {
            abilities = this.asThoughEffectsMap.get((Object)AsThoughEffectType.SPEND_OTHER_MANA).getAbility(effect.getId());
            for (Ability ability : abilities) {
                ManaType usableManaType;
                if ((affectedAbility != null || !effect.applies(objectId, ability, controllerId, game)) && !effect.applies(objectId, affectedAbility, ability, game, controllerId) || (usableManaType = ((AsThoughManaEffect)effect).getAsThoughManaType(manaType, mana, controllerId, ability, game)) == null) continue;
                return usableManaType;
            }
        }
        return manaType;
    }

    public List<AsThoughEffect> getApplicableAsThoughEffects(AsThoughEffectType type, Game game) {
        ArrayList<AsThoughEffect> asThoughEffectsList = new ArrayList<AsThoughEffect>();
        if (this.asThoughEffectsMap.containsKey((Object)type)) {
            block0: for (AsThoughEffect effect : this.asThoughEffectsMap.get((Object)type)) {
                Set<Ability> abilities = this.asThoughEffectsMap.get((Object)type).getAbility(effect.getId());
                for (Ability ability : abilities) {
                    if (ability instanceof StaticAbility && !ability.isInUseableZone(game, null, null) || effect.getDuration() == Duration.OneUse && effect.isUsed()) continue;
                    asThoughEffectsList.add(effect);
                    continue block0;
                }
            }
        }
        return asThoughEffectsList;
    }

    public Set<Ability> getAsThoughEffectsAbility(AsThoughEffect effect) {
        return this.asThoughEffectsMap.get((Object)effect.getAsThoughEffectType()).getAbility(effect.getId());
    }

    public void costModification(Ability abilityToModify, Game game) {
        Set<Ability> abilities;
        List<CostModificationEffect> costEffects = this.getApplicableCostModificationEffects(game);
        abilityToModify.adjustCostsPrepare(game);
        abilityToModify.adjustCostsModify(game, CostModificationType.INCREASE_COST);
        for (CostModificationEffect effect : costEffects) {
            if (effect.getModificationType() != CostModificationType.INCREASE_COST) continue;
            abilities = this.costModificationEffects.getAbility(effect.getId());
            for (Ability ability : abilities) {
                if (!effect.applies(abilityToModify, ability, game)) continue;
                effect.apply(game, ability, abilityToModify);
            }
        }
        abilityToModify.adjustCostsModify(game, CostModificationType.REDUCE_COST);
        for (CostModificationEffect effect : costEffects) {
            if (effect.getModificationType() != CostModificationType.REDUCE_COST) continue;
            abilities = this.costModificationEffects.getAbility(effect.getId());
            for (Ability ability : abilities) {
                if (!effect.applies(abilityToModify, ability, game)) continue;
                effect.apply(game, ability, abilityToModify);
            }
        }
        abilityToModify.adjustCostsModify(game, CostModificationType.SET_COST);
        for (CostModificationEffect effect : costEffects) {
            if (effect.getModificationType() != CostModificationType.SET_COST) continue;
            abilities = this.costModificationEffects.getAbility(effect.getId());
            for (Ability ability : abilities) {
                if (!effect.applies(abilityToModify, ability, game)) continue;
                effect.apply(game, ability, abilityToModify);
            }
        }
    }

    public void applySpliceEffects(Ability abilityToModify, Game game) {
        Player controller;
        List<SpliceCardEffect> spliceEffects = this.getApplicableSpliceCardEffects(game, abilityToModify.getControllerId());
        ArrayList<Ability> spliceAbilities = new ArrayList<Ability>();
        for (SpliceCardEffect effect : spliceEffects) {
            Set<Ability> abilities = this.spliceCardEffects.getAbility(effect.getId());
            for (Ability ability : abilities) {
                if (!effect.applies(abilityToModify, ability, game)) continue;
                spliceAbilities.add(ability);
            }
        }
        if (!spliceAbilities.isEmpty() && (controller = game.getPlayer(abilityToModify.getControllerId())).chooseUse(Outcome.Benefit, "Splice a card?", abilityToModify, game)) {
            CardsImpl cardsToReveal = new CardsImpl();
            do {
                FilterCard filter = new FilterCard("a card to splice");
                ArrayList<CardIdPredicate> idPredicates = new ArrayList<CardIdPredicate>();
                for (Ability ability : spliceAbilities) {
                    idPredicates.add(new CardIdPredicate(ability.getSourceId()));
                }
                filter.add(Predicates.or(idPredicates));
                TargetCardInHand targetCardInHand = new TargetCardInHand(filter);
                controller.chooseTarget(Outcome.Benefit, targetCardInHand, abilityToModify, game);
                UUID cardId = targetCardInHand.getFirstTarget();
                if (cardId == null) continue;
                Ability selectedAbility = null;
                for (Ability ability : spliceAbilities) {
                    if (!ability.getSourceId().equals(cardId)) continue;
                    selectedAbility = ability;
                    break;
                }
                if (selectedAbility == null) continue;
                SpliceCardEffect spliceEffect = (SpliceCardEffect)selectedAbility.getEffects().get(0);
                spliceEffect.apply(game, selectedAbility, abilityToModify);
                cardsToReveal.add(game.getCard(cardId));
                spliceAbilities.remove(selectedAbility);
            } while (!spliceAbilities.isEmpty() && controller.chooseUse(Outcome.Benefit, "Splice another card?", abilityToModify, game));
            controller.revealCards("Spliced cards", (Cards)cardsToReveal, game);
        }
    }

    public boolean preventedByRuleModification(GameEvent event, Ability targetAbility, Game game, boolean silentMode) {
        for (ContinuousRuleModifyingEffect effect : this.continuousRuleModifyingEffects) {
            if (!effect.checksEventType(event, game)) continue;
            for (Ability sourceAbility : this.continuousRuleModifyingEffects.getAbility(effect.getId())) {
                if (sourceAbility instanceof StaticAbility && !sourceAbility.isInUseableZone(game, null, event) || !this.checkAbilityStillExists(sourceAbility, effect, event, game) || effect.getDuration() == Duration.OneUse && effect.isUsed()) continue;
                effect.setValue("targetAbility", targetAbility);
                if (!effect.applies(event, sourceAbility, game)) continue;
                if (!game.inCheckPlayableState() && !silentMode) {
                    MageObject sourceObject = sourceAbility.getSourceObject(game);
                    String message = effect.getInfoMessage(sourceAbility, event, game);
                    if (sourceObject != null) {
                        message = sourceObject.getIdName() + ": " + message;
                    }
                    if (message != null && !message.isEmpty()) {
                        Player player;
                        if (effect.sendMessageToUser() && (player = game.getPlayer(event.getPlayerId())) != null && !game.isSimulation()) {
                            game.informPlayer(player, message);
                        }
                        if (effect.sendMessageToGameLog() && !game.isSimulation()) {
                            game.informPlayers(message);
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Game game) {
        boolean caught = false;
        HashMap consumed = new HashMap();
        while (true) {
            Set<UUID> set;
            int index;
            ReplacementEffect effect;
            Set<Ability> abilities;
            Map<ReplacementEffect, Set<Ability>> rEffects = this.getApplicableReplacementEffects(event, game);
            Iterator<ReplacementEffect> it1 = rEffects.keySet().iterator();
            while (it1.hasNext()) {
                ReplacementEffect entry = it1.next();
                if (!consumed.containsKey(entry.getId())) continue;
                Set consumedAbilitiesIds = (Set)consumed.get(entry.getId());
                if (rEffects.get(entry) == null || consumedAbilitiesIds.size() == rEffects.get(entry).size()) {
                    it1.remove();
                    continue;
                }
                Iterator<Ability> it = rEffects.get(entry).iterator();
                while (it.hasNext()) {
                    Ability ability = it.next();
                    if (!consumedAbilitiesIds.contains(ability.getId())) continue;
                    it.remove();
                }
            }
            if (rEffects.isEmpty()) break;
            boolean onlyOne = false;
            if (rEffects.size() == 1 && ((abilities = (effect = rEffects.keySet().iterator().next()).getEffectType() == EffectType.REPLACEMENT ? this.replacementEffects.getAbility(effect.getId()) : this.preventionEffects.getAbility(effect.getId())) == null || abilities.size() == 1)) {
                onlyOne = true;
            }
            if (onlyOne) {
                index = 0;
            } else {
                Player player = game.getPlayer(event.getPlayerId());
                LinkedHashMap<String, String> effectsMap = new LinkedHashMap<String, String>();
                LinkedHashMap<String, MageObject> objectsMap = new LinkedHashMap<String, MageObject>();
                this.prepareReplacementEffectMaps(rEffects, game, effectsMap, objectsMap);
                index = player.chooseReplacementEffect(effectsMap, objectsMap, game);
            }
            int checked = 0;
            Effect rEffect = null;
            MageItem rAbility = null;
            for (Map.Entry<ReplacementEffect, Set<Ability>> entry : rEffects.entrySet()) {
                if (entry.getValue() == null) {
                    if (checked == index) {
                        rEffect = entry.getKey();
                        break;
                    }
                    ++checked;
                    continue;
                }
                Set<Ability> abilities2 = entry.getValue();
                int size = abilities2.size();
                if (index > checked + size - 1) {
                    checked += size;
                    continue;
                }
                rEffect = entry.getKey();
                Iterator<Ability> it = abilities2.iterator();
                while (it.hasNext() && rAbility == null) {
                    if (checked == index) {
                        rAbility = it.next();
                        continue;
                    }
                    it.next();
                    ++checked;
                }
                break block3;
            }
            if (rEffect != null) {
                event.getAppliedEffects().add(rEffect.getId());
                caught = rEffect.replaceEvent(event, (Ability)rAbility, game);
                if (Duration.OneUse.equals((Object)rEffect.getDuration())) {
                    rEffect.discard();
                }
            }
            if (caught) break;
            if (rEffect == null) continue;
            if (consumed.containsKey(rEffect.getId())) {
                set = (Set)consumed.get(rEffect.getId());
                if (rAbility == null) continue;
                set.add(rAbility.getId());
                continue;
            }
            set = new HashSet();
            if (rAbility != null) {
                set.add(rAbility.getId());
            }
            consumed.put(rEffect.getId(), set);
        }
        return caught;
    }

    public synchronized void apply(Game game) {
        Set<Ability> abilities;
        Set<Ability> abilities2;
        this.removeInactiveEffects(game);
        List<ContinuousEffect> activeLayerEffects = this.getLayeredEffects(game);
        List<ContinuousEffect> layer = this.filterLayeredEffects(activeLayerEffects, Layer.CopyEffects_1);
        for (ContinuousEffect effect : layer) {
            abilities2 = this.layeredEffects.getAbility(effect.getId());
            for (Ability ability : abilities2) {
                effect.apply(Layer.CopyEffects_1, SubLayer.CopyEffects_1a, ability, game);
            }
        }
        for (ContinuousEffect effect : layer) {
            abilities2 = this.layeredEffects.getAbility(effect.getId());
            for (Ability ability : abilities2) {
                effect.apply(Layer.CopyEffects_1, SubLayer.FaceDownEffects_1b, ability, game);
            }
        }
        if (!layer.isEmpty()) {
            activeLayerEffects = this.getLayeredEffects(game, "layer_1");
        }
        layer = this.filterLayeredEffects(activeLayerEffects, Layer.ControlChangingEffects_2);
        while (true) {
            for (ContinuousEffect effect : layer) {
                abilities2 = this.layeredEffects.getAbility(effect.getId());
                for (Ability ability : abilities2) {
                    effect.apply(Layer.ControlChangingEffects_2, SubLayer.NA, ability, game);
                }
            }
            if (!game.getBattlefield().fireControlChangeEvents(game)) break;
            game.getBattlefield().resetPermanentsControl();
        }
        this.applyLayer(activeLayerEffects, Layer.TextChangingEffects_3, game, "layer_3");
        activeLayerEffects = this.getLayeredEffects(game, "layer_3");
        this.applyLayer(activeLayerEffects, Layer.TypeChangingEffects_4, game, "layer_4");
        activeLayerEffects = this.getLayeredEffects(game, "layer_4");
        this.applyLayer(activeLayerEffects, Layer.ColorChangingEffects_5, game, "layer_5");
        activeLayerEffects = this.getLayeredEffects(game, "layer_5");
        HashMap<ContinuousEffect, List<Ability>> appliedEffectAbilities = new HashMap<ContinuousEffect, List<Ability>>();
        boolean done = false;
        LinkedHashMap<ContinuousEffect, Set<UUID>> waitingEffects = new LinkedHashMap<ContinuousEffect, Set<UUID>>();
        HashSet<UUID> appliedEffects = new HashSet<UUID>();
        this.applyStatus.apply(Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, null, game);
        activeLayerEffects = this.getLayeredEffects(game, "layer_6");
        while (!done) {
            done = true;
            layer = this.filterLayeredEffects(activeLayerEffects, Layer.AbilityAddingRemovingEffects_6);
            for (ContinuousEffect effect : layer) {
                if (!activeLayerEffects.contains(effect) || appliedEffects.contains(effect.getId())) continue;
                Set<UUID> dependentTo = effect.isDependentTo(layer);
                if (!appliedEffects.containsAll(dependentTo)) {
                    waitingEffects.entrySet().stream().filter(entry -> dependentTo.contains(((ContinuousEffect)entry.getKey()).getId()) && ((Set)entry.getValue()).contains(effect.getId())).forEach(entry -> {
                        ((Set)entry.getValue()).remove(effect.getId());
                        dependentTo.remove(((ContinuousEffect)entry.getKey()).getId());
                    });
                    waitingEffects.entrySet().removeIf(x -> x.getValue() == null || ((Set)x.getValue()).isEmpty());
                    if (!dependentTo.isEmpty() && !waitingEffects.containsKey(effect)) {
                        waitingEffects.put(effect, dependentTo);
                        continue;
                    }
                }
                List<Ability> appliedAbilities = (ArrayList<Ability>)appliedEffectAbilities.get(effect);
                Set<Ability> abilities3 = this.layeredEffects.getAbility(effect.getId());
                for (Ability ability : abilities3) {
                    if (appliedAbilities != null && appliedAbilities.contains(ability)) continue;
                    if (appliedAbilities == null) {
                        appliedAbilities = new ArrayList<Ability>();
                        appliedEffectAbilities.put(effect, appliedAbilities);
                    }
                    appliedAbilities.add(ability);
                    effect.apply(Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, ability, game);
                    done = false;
                    activeLayerEffects = this.getLayeredEffects(game, "apply");
                }
                appliedEffects.add(effect.getId());
                if (waitingEffects.isEmpty()) continue;
                Iterator iterator = waitingEffects.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry2 = iterator.next();
                    if (!appliedEffects.containsAll((Collection)entry2.getValue())) continue;
                    appliedAbilities = (List)appliedEffectAbilities.get(entry2.getKey());
                    abilities3 = this.layeredEffects.getAbility(((ContinuousEffect)entry2.getKey()).getId());
                    for (Ability ability : abilities3) {
                        if (appliedAbilities != null && appliedAbilities.contains(ability)) continue;
                        if (appliedAbilities == null) {
                            appliedAbilities = new ArrayList();
                            appliedEffectAbilities.put((ContinuousEffect)entry2.getKey(), appliedAbilities);
                        }
                        appliedAbilities.add(ability);
                        ((ContinuousEffect)entry2.getKey()).apply(Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, ability, game);
                        done = false;
                        activeLayerEffects = this.getLayeredEffects(game, "apply");
                    }
                    appliedEffects.add(((ContinuousEffect)entry2.getKey()).getId());
                    iterator.remove();
                }
            }
        }
        layer = this.filterLayeredEffects(activeLayerEffects, Layer.PTChangingEffects_7);
        for (ContinuousEffect effect : layer) {
            abilities = this.layeredEffects.getAbility(effect.getId());
            for (Ability ability : abilities) {
                if (!this.abilityActive(ability, game)) continue;
                effect.apply(Layer.PTChangingEffects_7, SubLayer.CharacteristicDefining_7a, ability, game);
            }
        }
        for (ContinuousEffect effect : layer) {
            abilities = this.layeredEffects.getAbility(effect.getId());
            for (Ability ability : abilities) {
                effect.apply(Layer.PTChangingEffects_7, SubLayer.SetPT_7b, ability, game);
            }
        }
        for (ContinuousEffect effect : layer) {
            abilities = this.layeredEffects.getAbility(effect.getId());
            for (Ability ability : abilities) {
                effect.apply(Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, ability, game);
            }
        }
        this.applyStatus.apply(Layer.PTChangingEffects_7, SubLayer.Counters_7d, null, game);
        for (ContinuousEffect effect : layer) {
            abilities = this.layeredEffects.getAbility(effect.getId());
            for (Ability ability : abilities) {
                effect.apply(Layer.PTChangingEffects_7, SubLayer.SwitchPT_e, ability, game);
            }
        }
        layer = this.filterLayeredEffects(activeLayerEffects, Layer.PlayerEffects);
        for (ContinuousEffect effect : layer) {
            abilities = this.layeredEffects.getAbility(effect.getId());
            for (Ability ability : abilities) {
                effect.apply(Layer.PlayerEffects, SubLayer.NA, ability, game);
            }
        }
        layer = this.filterLayeredEffects(activeLayerEffects, Layer.RulesEffects);
        for (ContinuousEffect effect : layer) {
            abilities = this.layeredEffects.getAbility(effect.getId());
            for (Ability ability : abilities) {
                effect.apply(Layer.RulesEffects, SubLayer.NA, ability, game);
            }
        }
    }

    private boolean abilityActive(Ability ability, Game game) {
        MageObject object = game.getObject(ability.getSourceId());
        return object != null && object.hasAbility(ability, game);
    }

    private void applyLayer(List<ContinuousEffect> activeLayerEffects, Layer currentLayer, Game game, String timestampGroupName) {
        List<ContinuousEffect> layer = this.filterLayeredEffects(activeLayerEffects, currentLayer);
        if (!layer.isEmpty()) {
            int numberOfEffects = layer.size();
            HashSet<UUID> appliedEffects = new HashSet<UUID>();
            LinkedHashMap<ContinuousEffect, Set<UUID>> waitingEffects = new LinkedHashMap<ContinuousEffect, Set<UUID>>();
            for (ContinuousEffect effect : layer) {
                Set<UUID> dependentTo;
                if (numberOfEffects > 1 && !appliedEffects.containsAll(dependentTo = effect.isDependentTo(layer))) {
                    waitingEffects.put(effect, dependentTo);
                    continue;
                }
                this.applyContinuousEffect(effect, currentLayer, game);
                appliedEffects.add(effect.getId());
                layer = this.getLayeredEffects(game, timestampGroupName);
                if (!waitingEffects.isEmpty()) {
                    for (Map.Entry entry : waitingEffects.entrySet()) {
                        if (!appliedEffects.containsAll((Collection)entry.getValue())) continue;
                        this.applyContinuousEffect((ContinuousEffect)entry.getKey(), currentLayer, game);
                        appliedEffects.add(((ContinuousEffect)entry.getKey()).getId());
                        layer = this.getLayeredEffects(game, timestampGroupName);
                    }
                }
                if (numberOfEffects == appliedEffects.size()) continue;
                for (Map.Entry entry : waitingEffects.entrySet()) {
                    if (!appliedEffects.containsAll((Collection)entry.getValue())) continue;
                    this.applyContinuousEffect((ContinuousEffect)entry.getKey(), currentLayer, game);
                    appliedEffects.add(((ContinuousEffect)entry.getKey()).getId());
                    layer = this.getLayeredEffects(game, timestampGroupName);
                }
            }
        }
    }

    private void applyContinuousEffect(ContinuousEffect effect, Layer currentLayer, Game game) {
        Set<Ability> abilities = this.layeredEffects.getAbility(effect.getId());
        for (Ability ability : abilities) {
            if (!this.isAbilityStillExists(game, ability, effect)) continue;
            effect.apply(currentLayer, SubLayer.NA, ability, game);
        }
    }

    private boolean isAbilityStillExists(Game game, Ability ability, ContinuousEffect effect) {
        switch (effect.getDuration()) {
            case EndOfCombat: 
            case EndOfGame: 
            case EndOfStep: 
            case EndOfTurn: 
            case OneUse: 
            case Custom: {
                return true;
            }
        }
        Permanent card = game.getPermanentOrLKIBattlefield(ability.getSourceId());
        return effect instanceof BecomesFaceDownCreatureEffect || effect == null || card == null || card.hasAbility(ability, game);
    }

    public Set<Ability> getLayeredEffectAbilities(ContinuousEffect effect) {
        return this.layeredEffects.getAbility(effect.getId());
    }

    public synchronized void addEffect(ContinuousEffect effect, UUID sourceId, Ability source) {
        if (!(source instanceof MageSingleton)) {
            effect.setTemporary(true);
        }
        this.addEffect(effect, source);
    }

    public synchronized void addEffect(ContinuousEffect effect, Ability source) {
        if (effect == null || source == null) {
            throw new IllegalArgumentException("Wrong code usage. Effect and source can't be null here: " + source + "; " + effect);
        }
        switch (effect.getEffectType()) {
            case REPLACEMENT: 
            case REDIRECTION: {
                this.replacementEffects.addEffect((ReplacementEffect)effect, source);
                break;
            }
            case PREVENTION: {
                this.preventionEffects.addEffect((PreventionEffect)effect, source);
                break;
            }
            case RESTRICTION: {
                this.restrictionEffects.addEffect((RestrictionEffect)effect, source);
                break;
            }
            case RESTRICTION_UNTAP_NOT_MORE_THAN: {
                this.restrictionUntapNotMoreThanEffects.addEffect((RestrictionUntapNotMoreThanEffect)effect, source);
                break;
            }
            case REQUIREMENT: {
                this.requirementEffects.addEffect((RequirementEffect)effect, source);
                break;
            }
            case ASTHOUGH: {
                AsThoughEffect newAsThoughEffect = (AsThoughEffect)effect;
                this.asThoughEffectsMap.computeIfAbsent(newAsThoughEffect.getAsThoughEffectType(), x -> {
                    ContinuousEffectsList list = new ContinuousEffectsList();
                    this.allEffectsLists.add(list);
                    return list;
                }).addEffect(newAsThoughEffect, source);
                break;
            }
            case COSTMODIFICATION: {
                this.costModificationEffects.addEffect((CostModificationEffect)effect, source);
                break;
            }
            case SPLICE: {
                this.spliceCardEffects.addEffect((SpliceCardEffect)effect, source);
                break;
            }
            case CONTINUOUS_RULE_MODIFICATION: {
                this.continuousRuleModifyingEffects.addEffect((ContinuousRuleModifyingEffect)effect, source);
                break;
            }
            case CONTINUOUS: 
            case ONESHOT: {
                this.layeredEffects.addEffect(effect, source);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown effect type: " + (Object)((Object)effect.getEffectType()));
            }
        }
    }

    public synchronized void setController(UUID cardId, UUID controllerId) {
        for (ContinuousEffectsList<?> effectsList : this.allEffectsLists) {
            this.setControllerForEffect(effectsList, cardId, controllerId);
        }
    }

    private void setControllerForEffect(ContinuousEffectsList<?> effects, UUID sourceId, UUID controllerId) {
        for (ContinuousEffect effect : effects) {
            if (effect.getDuration().isFixedController()) continue;
            Set<Ability> abilities = effects.getAbility(effect.getId());
            for (Ability ability : abilities) {
                if (ability.getSourceId() != null) {
                    if (!ability.getSourceId().equals(sourceId)) continue;
                    ability.setControllerId(controllerId);
                    continue;
                }
                if (ability.getZone() == Zone.COMMAND) continue;
                logger.fatal((Object)("Continuous effect for ability with no sourceId Ability: " + ability));
            }
        }
    }

    public synchronized void clear() {
        for (ContinuousEffectsList<?> effectsList : this.allEffectsLists) {
            effectsList.clear();
        }
    }

    public synchronized void removeAllTemporaryEffects() {
        for (ContinuousEffectsList<?> effectsList : this.allEffectsLists) {
            effectsList.removeTemporaryEffects();
        }
    }

    public void prepareReplacementEffectMaps(Map<ReplacementEffect, Set<Ability>> rEffects, Game game, Map<String, String> effectsMap, Map<String, MageObject> objectsMap) {
        if (!(effectsMap instanceof LinkedHashMap) || !(objectsMap instanceof LinkedHashMap)) {
            throw new IllegalArgumentException("Wrong code usage: must use LinkedHashMap only");
        }
        effectsMap.clear();
        objectsMap.clear();
        for (Map.Entry<ReplacementEffect, Set<Ability>> entry : rEffects.entrySet()) {
            if (entry.getValue() != null) {
                for (Ability ability : entry.getValue()) {
                    MageObject object = game.getObject(ability.getSourceId());
                    String key = ability.getId().toString() + '_' + entry.getKey().getId().toString();
                    if (object != null) {
                        effectsMap.put(key, object.getIdName() + ": " + ability.getRule(object.getName()));
                        objectsMap.put(key, object);
                        continue;
                    }
                    effectsMap.put(key, entry.getKey().getText(ability.getModes().getMode()));
                    objectsMap.put(key, null);
                }
                continue;
            }
            if (entry.getKey() instanceof AuraReplacementEffect) continue;
            logger.error((Object)("Replacement effect without ability: " + entry.getKey().toString()));
        }
    }

    public boolean existRequirementEffects() {
        return !this.requirementEffects.isEmpty();
    }

    public UUID getControllerOfSourceId(UUID sourceId) {
        Set<Ability> abilities;
        UUID controllerFound = null;
        for (PreventionEffect preventionEffect : this.preventionEffects) {
            abilities = this.preventionEffects.getAbility(preventionEffect.getId());
            for (Ability ability : abilities) {
                if (!ability.getSourceId().equals(sourceId)) continue;
                if (controllerFound == null || controllerFound.equals(ability.getControllerId())) {
                    controllerFound = ability.getControllerId();
                    continue;
                }
                return null;
            }
        }
        for (ReplacementEffect replacementEffect : this.replacementEffects) {
            abilities = this.replacementEffects.getAbility(replacementEffect.getId());
            for (Ability ability : abilities) {
                if (ability.getSourceId() != null) {
                    if (!ability.getSourceId().equals(sourceId)) continue;
                    if (controllerFound == null || controllerFound.equals(ability.getControllerId())) {
                        controllerFound = ability.getControllerId();
                        continue;
                    }
                    return null;
                }
                if (replacementEffect instanceof CommanderReplacementEffect) continue;
                logger.warn((Object)("Ability without sourceId:" + ability.getRule()));
            }
        }
        return controllerFound;
    }

    public int getTotalEffectsCount() {
        return this.allEffectsLists.stream().mapToInt(ArrayList::size).sum();
    }

    public String toString() {
        return "Effects: " + this.getTotalEffectsCount();
    }
}

