/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.ContinuousRuleModifyingEffect;
import mage.constants.Duration;
import mage.constants.EffectType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

public abstract class ContinuousRuleModifyingEffectImpl
extends ContinuousEffectImpl
implements ContinuousRuleModifyingEffect {
    protected final boolean messageToUser;
    protected final boolean messageToGameLog;
    protected final String infoMessage;

    public ContinuousRuleModifyingEffectImpl(Duration duration, Outcome outcome) {
        this(duration, outcome, false, true);
    }

    public ContinuousRuleModifyingEffectImpl(Duration duration, Outcome outcome, boolean messageToUser, boolean messageToLog) {
        super(duration, outcome);
        this.effectType = EffectType.CONTINUOUS_RULE_MODIFICATION;
        this.infoMessage = null;
        this.messageToUser = messageToUser;
        this.messageToGameLog = messageToLog;
    }

    protected ContinuousRuleModifyingEffectImpl(ContinuousRuleModifyingEffectImpl effect) {
        super(effect);
        this.infoMessage = effect.infoMessage;
        this.messageToUser = effect.messageToUser;
        this.messageToGameLog = effect.messageToGameLog;
    }

    @Override
    public final boolean apply(Game game, Ability source) {
        throw new IllegalStateException("Wrong code usage. Rules modifying effects don't use apply methods");
    }

    @Override
    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        if (this.infoMessage == null) {
            MageObject object = game.getObject(source);
            String message = object != null ? source.getRule(this.messageToUser ? object.getIdName() : object.getLogName()) : source.getRule();
            return message;
        }
        return this.infoMessage;
    }

    @Override
    public boolean sendMessageToUser() {
        return this.messageToUser;
    }

    @Override
    public boolean sendMessageToGameLog() {
        return this.messageToGameLog;
    }
}

