/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.condition.Condition;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.Effects;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.EnterEventType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;

public class EntersBattlefieldEffect
extends ReplacementEffectImpl {
    private final Effects baseEffects;
    private final String text;
    private final Condition condition;
    private final boolean optional;
    private final EnterEventType enterEventType;
    public static final String SOURCE_CAST_SPELL_ABILITY = "sourceCastSpellAbility";

    public EntersBattlefieldEffect(Effect baseEffect) {
        this(baseEffect, "");
    }

    public EntersBattlefieldEffect(Effect baseEffect, String text) {
        this(baseEffect, null, text, true, false);
    }

    public EntersBattlefieldEffect(Effect baseEffect, String text, boolean optional) {
        this(baseEffect, null, text, true, optional);
    }

    public EntersBattlefieldEffect(Effect baseEffect, Condition condition, String text, boolean selfScope, boolean optional) {
        this(baseEffect, condition, text, selfScope, optional, EnterEventType.OTHER);
    }

    public EntersBattlefieldEffect(Effect baseEffect, Condition condition, String text, boolean selfScope, boolean optional, EnterEventType enterEventType) {
        super(Duration.WhileOnBattlefield, baseEffect.getOutcome(), selfScope);
        this.baseEffects = new Effects(new Effect[0]);
        this.baseEffects.add(baseEffect);
        this.enterEventType = enterEventType;
        this.text = text;
        this.condition = condition;
        this.optional = optional;
    }

    protected EntersBattlefieldEffect(EntersBattlefieldEffect effect) {
        super(effect);
        this.baseEffects = effect.baseEffects.copy();
        this.text = effect.text;
        this.condition = effect.condition;
        this.optional = effect.optional;
        this.enterEventType = effect.enterEventType;
    }

    public void addEffect(Effect effect) {
        this.baseEffects.add(effect);
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        switch (this.enterEventType) {
            case OTHER: {
                return GameEvent.EventType.ENTERS_THE_BATTLEFIELD == event.getType();
            }
            case SELF: {
                return GameEvent.EventType.ENTERS_THE_BATTLEFIELD_SELF == event.getType();
            }
            case CONTROL: {
                return GameEvent.EventType.ENTERS_THE_BATTLEFIELD_CONTROL == event.getType();
            }
            case COPY: {
                return GameEvent.EventType.ENTERS_THE_BATTLEFIELD_COPY == event.getType();
            }
        }
        return false;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId().equals(source.getSourceId()) && (this.condition == null || this.condition.apply(game, source));
    }

    @Override
    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        StackObject stackObject;
        Spell entersBySpell;
        if (this.optional) {
            Player controller = game.getPlayer(source.getControllerId());
            MageObject object = game.getPermanentEntering(source.getSourceId());
            if (object == null) {
                object = game.getObject(source);
            }
            if (controller == null || object == null) {
                return false;
            }
            if (!controller.chooseUse(this.outcome, "Use effect of " + object.getLogName() + '?', source, game)) {
                return false;
            }
        }
        if ((entersBySpell = game.getStack().getSpell(event.getSourceId())) == null && (stackObject = (StackObject)game.getLastKnownInformation(event.getSourceId(), Zone.STACK)) instanceof Spell) {
            entersBySpell = (Spell)stackObject;
        }
        for (Effect effect : this.baseEffects) {
            if (effect instanceof ContinuousEffect) {
                game.addEffect((ContinuousEffect)effect, source);
                continue;
            }
            if (entersBySpell != null) {
                effect.setValue(SOURCE_CAST_SPELL_ABILITY, entersBySpell.getSpellAbility());
            }
            effect.setValue("appliedEffects", event.getAppliedEffects());
            effect.apply(game, source);
        }
        return false;
    }

    @Override
    public String getText(Mode mode) {
        return this.text == null || this.text.isEmpty() ? this.baseEffects.getText(mode) : this.text;
    }

    @Override
    public EntersBattlefieldEffect copy() {
        return new EntersBattlefieldEffect(this);
    }
}

