/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.PreventionEffect;
import mage.abilities.effects.PreventionEffectData;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.EffectType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;

public abstract class PreventionEffectImpl
extends ReplacementEffectImpl
implements PreventionEffect {
    protected DynamicValue amountToPreventDynamic;
    protected int amountToPrevent;
    protected final boolean onlyCombat;
    protected boolean consumable;

    protected PreventionEffectImpl(Duration duration) {
        this(duration, Integer.MAX_VALUE, false);
    }

    protected PreventionEffectImpl(Duration duration, int amountToPrevent, boolean onlyCombat) {
        this(duration, amountToPrevent, onlyCombat, true);
    }

    protected PreventionEffectImpl(Duration duration, int amountToPrevent, boolean onlyCombat, boolean consumable) {
        this(duration, amountToPrevent, onlyCombat, consumable, null);
    }

    protected PreventionEffectImpl(Duration duration, int amountToPrevent, boolean onlyCombat, boolean consumable, DynamicValue amountToPreventDynamic) {
        super(duration, Outcome.PreventDamage);
        this.effectType = EffectType.PREVENTION;
        this.amountToPrevent = amountToPrevent;
        this.amountToPreventDynamic = amountToPreventDynamic;
        this.onlyCombat = onlyCombat;
        this.consumable = consumable;
    }

    protected PreventionEffectImpl(PreventionEffectImpl effect) {
        super(effect);
        this.amountToPrevent = effect.amountToPrevent;
        this.amountToPreventDynamic = effect.amountToPreventDynamic;
        this.onlyCombat = effect.onlyCombat;
        this.consumable = effect.consumable;
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        if (this.amountToPreventDynamic != null) {
            this.amountToPrevent = this.amountToPreventDynamic.calculate(game, source, this);
        }
    }

    protected PreventionEffectData preventDamageAction(GameEvent event, Ability source, Game game) {
        PreventionEffectData preventionData = game.preventDamage(event, source, game, this.amountToPrevent);
        if (!preventionData.isError() && !preventionData.isReplaced()) {
            if (this.consumable) {
                this.amountToPrevent = preventionData.getRemainingAmount();
            }
            if (this.amountToPrevent == 0) {
                this.discard();
            }
        }
        return preventionData;
    }

    @Override
    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        this.preventDamageAction(event, source, game);
        return false;
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGE_PERMANENT: 
            case DAMAGE_PLAYER: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getFlag() && (!this.onlyCombat || ((DamageEvent)event).isCombatDamage());
    }
}

