/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.abilities.effects.common.ExileAdventureSpellEffect;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;

class AdventureCastFromExileEffect
extends AsThoughEffectImpl {
    public AdventureCastFromExileEffect() {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.Custom, Outcome.Benefit);
        this.staticText = "Then exile this card. You may cast the creature later from exile.";
    }

    protected AdventureCastFromExileEffect(AdventureCastFromExileEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return true;
    }

    @Override
    public AdventureCastFromExileEffect copy() {
        return new AdventureCastFromExileEffect(this);
    }

    @Override
    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        UUID targetId = this.getTargetPointer().getFirst(game, source);
        ExileZone adventureExileZone = game.getExile().getExileZone(ExileAdventureSpellEffect.adventureExileId(affectedControllerId, game));
        if (targetId == null) {
            this.discard();
        } else if (objectId.equals(targetId) && affectedControllerId.equals(source.getControllerId()) && adventureExileZone.contains(objectId)) {
            Card card = game.getCard(objectId);
            return card != null;
        }
        return false;
    }
}

