/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterControlledLandPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInHand;
import mage.target.common.TargetControlledPermanent;

public class BalanceEffect
extends OneShotEffect {
    private static final FilterControlledLandPermanent filterLand = new FilterControlledLandPermanent("lands to keep");
    private static final FilterControlledCreaturePermanent filterCreature = new FilterControlledCreaturePermanent("creatures to keep");
    private static final FilterCard filterCardHand = new FilterCard("cards to keep");

    public BalanceEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "each player chooses a number of lands they control equal to the number of lands controlled by the player who controls the fewest, then sacrifices the rest. Players discard cards and sacrifice creatures the same way";
    }

    private BalanceEffect(BalanceEffect effect) {
        super(effect);
    }

    @Override
    public BalanceEffect copy() {
        return new BalanceEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        this.choosePermanentsToKeep(game, source, controller, filterLand);
        this.choosePermanentsToKeep(game, source, controller, filterCreature);
        int lowestHandSize = Integer.MAX_VALUE;
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            Player player2 = game.getPlayer(playerId);
            if (player2 == null) continue;
            lowestHandSize = Math.min(lowestHandSize, player2.getHand().size());
        }
        HashMap<UUID, CardsImpl> cardsToDiscard = new HashMap<UUID, CardsImpl>();
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            player = game.getPlayer(playerId);
            if (player == null) continue;
            Set<Card> allCardsInHand = player.getHand().getCards(game);
            LinkedHashSet<Card> cardsToKeep = new LinkedHashSet<Card>();
            if (lowestHandSize > 0) {
                TargetCardInHand target = new TargetCardInHand(lowestHandSize, filterCardHand);
                if (target.choose(Outcome.Protect, player.getId(), source.getSourceId(), source, game)) {
                    for (Card card : allCardsInHand) {
                        if (card == null || !target.getTargets().contains(card.getId())) continue;
                        cardsToKeep.add(card);
                    }
                } else {
                    int numCards = 0;
                    for (Card card : allCardsInHand) {
                        if (numCards < lowestHandSize) {
                            if (card == null) continue;
                            cardsToKeep.add(card);
                            ++numCards;
                            continue;
                        }
                        break;
                    }
                }
            }
            cardsToDiscard.put(playerId, allCardsInHand.stream().filter(e -> !cardsToKeep.contains(e)).collect(CardsImpl::new, CardsImpl::add, AbstractCollection::addAll));
        }
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            player = game.getPlayer(playerId);
            if (player == null || cardsToDiscard.get(playerId) == null) continue;
            player.discard((Cards)cardsToDiscard.get(playerId), false, source, game);
        }
        return true;
    }

    private void choosePermanentsToKeep(Game game, Ability source, Player controller, FilterControlledPermanent filterPermanent) {
        int lowestPermanentsCount = Integer.MAX_VALUE;
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            lowestPermanentsCount = Math.min(lowestPermanentsCount, game.getBattlefield().countAll(filterPermanent, player.getId(), game));
        }
        ArrayList permanentsToSacrifice = new ArrayList();
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            List<Permanent> allPermanentsOfType = game.getBattlefield().getActivePermanents(filterPermanent, player.getId(), source, game);
            ArrayList<Permanent> permanentsToKeep = new ArrayList<Permanent>();
            if (lowestPermanentsCount > 0) {
                TargetControlledPermanent target = new TargetControlledPermanent(lowestPermanentsCount, lowestPermanentsCount, filterPermanent, true);
                if (target.choose(Outcome.Protect, player.getId(), source.getSourceId(), source, game)) {
                    for (Permanent permanent : allPermanentsOfType) {
                        if (permanent == null || !target.getTargets().contains(permanent.getId())) continue;
                        permanentsToKeep.add(permanent);
                    }
                } else {
                    int numPermanents = 0;
                    for (Permanent permanent : allPermanentsOfType) {
                        if (numPermanents < lowestPermanentsCount) {
                            if (permanent == null) continue;
                            permanentsToKeep.add(permanent);
                            ++numPermanents;
                            continue;
                        }
                        break;
                    }
                }
            }
            List playerPermanentsToSacrifice = allPermanentsOfType.stream().filter(e -> !permanentsToKeep.contains(e)).collect(Collectors.toList());
            permanentsToSacrifice.addAll(playerPermanentsToSacrifice);
            if (playerPermanentsToSacrifice.isEmpty()) continue;
            game.informPlayers(player.getLogName() + " chose permanents to be sacrificed: " + playerPermanentsToSacrifice.stream().map(MageObject::getLogName).collect(Collectors.joining(", ")));
        }
        for (Permanent permanent : permanentsToSacrifice) {
            if (permanent == null) continue;
            permanent.sacrifice(source, game);
        }
    }
}

