/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

public class CantActivateAbilitiesAttachedEffect
extends ContinuousRuleModifyingEffectImpl {
    public CantActivateAbilitiesAttachedEffect() {
        super(Duration.WhileOnBattlefield, Outcome.UnboostCreature);
        this.staticText = "Enchanted creature's activated abilities can't be activated";
    }

    protected CantActivateAbilitiesAttachedEffect(CantActivateAbilitiesAttachedEffect effect) {
        super(effect);
    }

    @Override
    public CantActivateAbilitiesAttachedEffect copy() {
        return new CantActivateAbilitiesAttachedEffect(this);
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATE_ABILITY;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent enchantment = game.getPermanent(source.getSourceId());
        return enchantment != null && enchantment.getAttachedTo() != null && event.getSourceId().equals(enchantment.getAttachedTo());
    }
}

