/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;

public class CantBeCounteredSourceEffect
extends ContinuousRuleModifyingEffectImpl {
    public CantBeCounteredSourceEffect() {
        super(Duration.WhileOnStack, Outcome.Benefit, false, true);
        this.staticText = "this spell can't be countered";
    }

    protected CantBeCounteredSourceEffect(CantBeCounteredSourceEffect effect) {
        super(effect);
    }

    @Override
    public CantBeCounteredSourceEffect copy() {
        return new CantBeCounteredSourceEffect(this);
    }

    @Override
    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        StackObject stackObject = game.getStack().getStackObject(event.getSourceId());
        MageObject sourceObject = game.getObject(source);
        if (stackObject != null && sourceObject != null) {
            return sourceObject.getLogName() + " can't be countered by " + stackObject.getName();
        }
        return this.staticText;
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTER;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        Spell spell = game.getStack().getSpell(event.getTargetId());
        return spell != null && spell.getSourceId().equals(source.getSourceId());
    }
}

