/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.ChoiceCreatureType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

public class ChooseCreatureTypeEffect
extends OneShotEffect {
    public ChooseCreatureTypeEffect(Outcome outcome) {
        super(outcome);
        this.staticText = "choose a creature type";
    }

    protected ChooseCreatureTypeEffect(ChooseCreatureTypeEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        ChoiceCreatureType typeChoice;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject mageObject = game.getPermanentEntering(source.getSourceId());
        if (mageObject == null) {
            mageObject = game.getObject(source);
        }
        if (controller != null && mageObject != null && controller.choose(this.outcome, typeChoice = new ChoiceCreatureType(game, source), game)) {
            if (!game.isSimulation()) {
                game.informPlayers(mageObject.getName() + ": " + controller.getLogName() + " has chosen " + typeChoice.getChoiceKey());
            }
            game.getState().setValue(source.getSourceId() + "_type", SubType.byDescription(typeChoice.getChoiceKey()));
            if (mageObject instanceof Permanent) {
                ((Permanent)mageObject).addInfo("chosen type", CardUtil.addToolTipMarkTags("Chosen type: " + typeChoice.getChoiceKey()), game);
            }
            return true;
        }
        return false;
    }

    @Override
    public ChooseCreatureTypeEffect copy() {
        return new ChooseCreatureTypeEffect(this);
    }

    public static SubType getChosenCreatureType(UUID objectId, Game game) {
        return ChooseCreatureTypeEffect.getChosenCreatureType(objectId, game, "_type");
    }

    public static SubType getChosenCreatureType(UUID objectId, Game game, String typePostfix) {
        SubType creatureType = null;
        Object savedCreatureType = game.getState().getValue(objectId + typePostfix);
        if (savedCreatureType != null) {
            creatureType = SubType.byDescription(savedCreatureType.toString());
        }
        return creatureType;
    }
}

