/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ClashTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetOpponent;
import mage.target.targetpointer.FixedTarget;

public class ClashEffect
extends OneShotEffect {
    public ClashEffect() {
        super(Outcome.Benefit);
        this.staticText = "Clash with an opponent";
    }

    protected ClashEffect(ClashEffect effect) {
        super(effect);
    }

    @Override
    public ClashEffect copy() {
        return new ClashEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        TargetOpponent target = new TargetOpponent(true);
        target.withTargetName("an opponent to clash with");
        if (!controller.choose(Outcome.Benefit, target, source, game)) {
            return false;
        }
        return new ClashTargetEffect().setTargetPointer(new FixedTarget(target.getFirstTarget())).apply(game, source);
    }
}

