/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

public class ClashTargetEffect
extends OneShotEffect {
    public ClashTargetEffect() {
        super(Outcome.Benefit);
        this.staticText = "Clash with an opponent";
    }

    protected ClashTargetEffect(ClashTargetEffect effect) {
        super(effect);
    }

    @Override
    public ClashTargetEffect copy() {
        return new ClashTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        CardsImpl cards;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null || game.replaceEvent(GameEvent.getEvent(GameEvent.EventType.CLASH, controller.getId(), source, controller.getId()))) {
            return false;
        }
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (opponent == null) {
            return false;
        }
        int cmcController = Integer.MIN_VALUE;
        Card cardController = null;
        boolean topController = true;
        int cmcOpponent = Integer.MIN_VALUE;
        Card cardOpponent = null;
        boolean topOpponent = true;
        StringBuilder message = new StringBuilder("Clash: ");
        message.append(controller.getLogName());
        if (controller.getLibrary().hasCards()) {
            cards = new CardsImpl();
            cardController = controller.getLibrary().getFromTop(game);
            cards.add(cardController);
            controller.revealCards(sourceObject.getIdName() + ": Clash card of " + controller.getName(), (Cards)cards, game);
            cmcController = cardController.getManaValue();
            message.append(" (").append(cmcController).append(')');
        } else {
            message.append(" no card");
        }
        message.append(" vs. ").append(opponent.getLogName());
        if (opponent.getLibrary().hasCards()) {
            cards = new CardsImpl();
            cardOpponent = opponent.getLibrary().getFromTop(game);
            cards.add(cardOpponent);
            opponent.revealCards(sourceObject.getIdName() + ": Clash card of " + opponent.getName(), (Cards)cards, game);
            cmcOpponent = cardOpponent.getManaValue();
            message.append(" (").append(cmcOpponent).append(')');
        } else {
            message.append(" no card");
        }
        message.append(" - ");
        if (cmcController > cmcOpponent) {
            message.append(controller.getLogName()).append(" won the clash");
        } else if (cmcController < cmcOpponent) {
            message.append(opponent.getLogName()).append(" won the clash");
        } else {
            message.append(" no winner ");
        }
        game.informPlayers(message.toString());
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            if (cardController != null && player.getId().equals(controller.getId())) {
                topController = player.chooseUse(Outcome.Detriment, "Put " + cardController.getLogName() + " back on top of your library? (otherwise it goes to bottom)", source, game);
                continue;
            }
            if (cardOpponent == null || !player.getId().equals(opponent.getId())) continue;
            topOpponent = player.chooseUse(Outcome.Detriment, "Put " + cardOpponent.getLogName() + " back on top of your library? (otherwise it goes to bottom)", source, game);
        }
        if (cardController != null) {
            controller.moveCardToLibraryWithInfo(cardController, source, game, Zone.LIBRARY, topController, true);
        }
        if (cardOpponent != null) {
            opponent.moveCardToLibraryWithInfo(cardOpponent, source, game, Zone.LIBRARY, topOpponent, true);
        }
        game.fireEvent(new GameEvent(GameEvent.EventType.CLASHED, opponent.getId(), source, controller.getId(), 0, cmcController > cmcOpponent));
        game.fireEvent(new GameEvent(GameEvent.EventType.CLASHED, controller.getId(), source, opponent.getId(), 0, cmcOpponent > cmcController));
        source.getEffects().setValue("clashOpponent", opponent.getId());
        return cmcController > cmcOpponent;
    }
}

