/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.PutCards;
import mage.game.Game;
import mage.players.Player;

public class CounterTargetWithReplacementEffect
extends OneShotEffect {
    private final PutCards putIt;

    public CounterTargetWithReplacementEffect(PutCards putIt) {
        super(Outcome.Detriment);
        this.putIt = putIt;
    }

    protected CounterTargetWithReplacementEffect(CounterTargetWithReplacementEffect effect) {
        super(effect);
        this.putIt = effect.putIt;
    }

    @Override
    public CounterTargetWithReplacementEffect copy() {
        return new CounterTargetWithReplacementEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            return game.getStack().counter(this.getTargetPointer().getFirst(game, source), source, game, this.putIt);
        }
        return false;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder("counter ");
        sb.append(this.getTargetPointer().describeTargets(mode.getTargets(), "it"));
        sb.append(". If that spell is countered this way, ");
        if (this.putIt == PutCards.EXILED) {
            sb.append("exile it instead of putting it into its owner's graveyard");
        } else {
            sb.append(this.putIt == PutCards.TOP_OR_BOTTOM ? "put that card " : "put it ");
            sb.append(this.putIt.getMessage(true, false));
            sb.append(" instead of into that player's graveyard");
        }
        return sb.toString();
    }
}

