/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.game.Game;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

public class CreateDelayedTriggeredAbilityEffect
extends OneShotEffect {
    private final DelayedTriggeredAbility ability;
    private final boolean copyTargets;
    private final String rulePrefix;
    private boolean copyToPointer = false;

    public CreateDelayedTriggeredAbilityEffect(DelayedTriggeredAbility ability) {
        this(ability, true);
    }

    public CreateDelayedTriggeredAbilityEffect(DelayedTriggeredAbility ability, boolean copyTargets) {
        this(ability, copyTargets, "");
    }

    public CreateDelayedTriggeredAbilityEffect(DelayedTriggeredAbility ability, boolean copyTargets, String rulePrefix) {
        super(ability.getEffects().getOutcome(ability));
        this.ability = ability;
        this.copyTargets = copyTargets;
        this.rulePrefix = rulePrefix;
    }

    protected CreateDelayedTriggeredAbilityEffect(CreateDelayedTriggeredAbilityEffect effect) {
        super(effect);
        this.ability = effect.ability.copy();
        this.copyTargets = effect.copyTargets;
        this.rulePrefix = effect.rulePrefix;
        this.copyToPointer = effect.copyToPointer;
    }

    @Override
    public CreateDelayedTriggeredAbilityEffect copy() {
        return new CreateDelayedTriggeredAbilityEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        DelayedTriggeredAbility delayedAbility = this.ability.copy();
        if (this.copyTargets) {
            if (this.copyToPointer || source.getTargets().isEmpty()) {
                delayedAbility.getEffects().setTargetPointer(this.getTargetPointer().copy());
            } else {
                delayedAbility.getTargets().addAll(source.getTargets());
                for (Effect effect : delayedAbility.getEffects()) {
                    effect.getTargetPointer().init(game, source);
                }
            }
        }
        game.addDelayedTriggeredAbility(delayedAbility, source);
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        if (this.ability.getRuleVisible()) {
            if (this.rulePrefix == null || this.rulePrefix.isEmpty()) {
                return CardUtil.getTextWithFirstCharLowerCase(this.ability.getRule());
            }
            return this.rulePrefix + this.ability.getRule();
        }
        return "";
    }

    @Override
    public void setValue(String key, Object value) {
        this.ability.getEffects().setValue(key, value);
        super.setValue(key, value);
    }

    @Override
    public CreateDelayedTriggeredAbilityEffect setTargetPointer(TargetPointer targetPointer) {
        this.ability.getEffects().setTargetPointer(targetPointer);
        super.setTargetPointer(targetPointer);
        return this;
    }

    public CreateDelayedTriggeredAbilityEffect withCopyToPointer(boolean copyToPointer) {
        this.copyToPointer = copyToPointer;
        return this;
    }

    @Override
    public CreateDelayedTriggeredAbilityEffect withTargetDescription(String target) {
        this.ability.getEffects().forEach(effect -> effect.withTargetDescription(target));
        super.withTargetDescription(target);
        return this;
    }
}

