/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.RoleType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;

public class CreateRoleAttachedTargetEffect
extends OneShotEffect {
    private final RoleType roleType;

    public CreateRoleAttachedTargetEffect(RoleType roleType) {
        super(Outcome.Benefit);
        this.roleType = roleType;
    }

    private CreateRoleAttachedTargetEffect(CreateRoleAttachedTargetEffect effect) {
        super(effect);
        this.roleType = effect.roleType;
    }

    @Override
    public CreateRoleAttachedTargetEffect copy() {
        return new CreateRoleAttachedTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        boolean result = false;
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent == null) continue;
            Token token = this.roleType.createToken(permanent, game, source);
            result |= !token.getLastAddedTokenIds().isEmpty();
        }
        return result;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "create a " + this.roleType.getName() + " Role token attached to " + this.getTargetPointer().describeTargets(mode.getTargets(), "that creature");
    }
}

