/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.SpecialAction;
import mage.abilities.effects.OneShotEffect;
import mage.game.Game;

public class CreateSpecialActionEffect
extends OneShotEffect {
    private final SpecialAction action;
    private final UUID newActionControllerId;

    public CreateSpecialActionEffect(SpecialAction action) {
        this(action, null);
    }

    public CreateSpecialActionEffect(SpecialAction action, UUID newActionControllerId) {
        super(action.getEffects().getOutcome(action));
        this.action = action;
        this.newActionControllerId = newActionControllerId;
    }

    protected CreateSpecialActionEffect(CreateSpecialActionEffect effect) {
        super(effect);
        this.action = (SpecialAction)effect.action.copy();
        this.newActionControllerId = effect.newActionControllerId;
    }

    @Override
    public CreateSpecialActionEffect copy() {
        return new CreateSpecialActionEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        SpecialAction newAction = (SpecialAction)this.action.copy();
        newAction.setSourceId(source.getSourceId());
        newAction.setControllerId(this.newActionControllerId != null ? this.newActionControllerId : source.getControllerId());
        newAction.getTargets().addAll(source.getTargets());
        game.getState().getSpecialActions().add(newAction);
        return true;
    }

    @Override
    public String getText(Mode mode) {
        return this.action.getRule();
    }
}

