/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.util.CardUtil;

public class CreateTokenTargetEffect
extends OneShotEffect {
    private Token token;
    private DynamicValue amount;
    private boolean tapped;
    private boolean attacking;

    public CreateTokenTargetEffect(Token token) {
        this(token, StaticValue.get(1));
    }

    public CreateTokenTargetEffect(Token token, int amount) {
        this(token, amount, false);
    }

    public CreateTokenTargetEffect(Token token, int amount, boolean tapped) {
        this(token, StaticValue.get(amount), tapped, false);
    }

    public CreateTokenTargetEffect(Token token, DynamicValue amount) {
        this(token, amount, false);
    }

    public CreateTokenTargetEffect(Token token, DynamicValue amount, boolean tapped) {
        this(token, amount, tapped, false);
    }

    public CreateTokenTargetEffect(Token token, DynamicValue amount, boolean tapped, boolean attacking) {
        super(Outcome.PutCreatureInPlay);
        this.token = token;
        this.amount = amount.copy();
        this.tapped = tapped;
        this.attacking = attacking;
    }

    protected CreateTokenTargetEffect(CreateTokenTargetEffect effect) {
        super(effect);
        this.amount = effect.amount;
        this.token = effect.token.copy();
        this.tapped = effect.tapped;
        this.attacking = effect.attacking;
    }

    @Override
    public CreateTokenTargetEffect copy() {
        return new CreateTokenTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        int value = this.amount.calculate(game, source, this);
        if (value > 0) {
            return this.token.putOntoBattlefield(value, game, source, this.getTargetPointer().getFirst(game, source), this.tapped, this.attacking, (UUID)this.getValue("playerToAttack"));
        }
        return true;
    }

    @Override
    public String getText(Mode mode) {
        String message;
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder(this.getTargetPointer().describeTargets(mode.getTargets(), "that player"));
        sb.append(" creates ");
        if (this.amount.toString().equals("1")) {
            sb.append("a ");
            if (this.tapped && !this.attacking) {
                sb.append("tapped ");
            }
            sb.append(this.token.getDescription());
        } else {
            int tokenLocation;
            sb.append(CardUtil.numberToText(this.amount.toString())).append(' ');
            if (this.tapped && !this.attacking) {
                sb.append("tapped ");
            }
            sb.append(this.token.getDescription());
            if (this.token.getDescription().endsWith("token")) {
                sb.append("s");
            }
            if ((tokenLocation = sb.indexOf("token ")) != -1) {
                sb.replace(tokenLocation, tokenLocation + 6, "tokens ");
            }
        }
        if (this.attacking) {
            sb.append(" that are");
            if (this.tapped) {
                sb.append(" tapped and");
            }
            sb.append(" attacking");
        }
        if (!(message = this.amount.getMessage()).isEmpty()) {
            if (this.amount.toString().equals("X")) {
                sb.append(", where X is ");
            } else {
                sb.append(" for each ");
            }
        }
        sb.append(message);
        return sb.toString();
    }
}

